/**
 * Copyright Intermesh
 *
 * This file is part of Group-Office. You should have received a copy of the
 * Group-Office license along with Group-Office. See the file /LICENSE.TXT
 *
 * If you have questions write an e-mail to info@intermesh.nl
 *
 * @version $Id: StandardTaskDialog.js 22922 2018-01-12 08:01:04Z mschering $
 * @copyright Copyright Intermesh
 * @author Michael de Hart <mdhart@intermesh.nl>
 */

/**
 * This is the dialog for create and update the Standard tasks / Activities
 * It is also used in the settings dialog of the time registration module
 */
Ext.define('go.modules.business.business.ActivityDialog', {
	extend: go.form.Dialog,

	entityStore: "Activity",
	goDialogId: 'business-activity',
	title: t("Activity type", "projects2"),
	width: dp(700),
	height: dp(600),
	resizable: false,

	initFormItems: function() {

		return[{xtype:"fieldset", items: [{
			name: 'code',
			xtype: 'textfield',
			fieldLabel: t("Code", "projects2"),
			width: 100,
			allowBlank:false
		},{
			xtype:'radiogroup',
			name: 'type',
			value: 1,
			allowBlank:false,
			fieldLabel: t("Type"),
			listeners: {
				change: function(cb, checked) {
					if(cb.getValue() === 4) {
						this.budgetableCb.checked = false;
						this.budgetableCb.hide();
						this.budgetExpiresCb.checked = false;
						// this.budgetExpiresCb.hide();
					} else {
						this.budgetableCb.show();
						// this.budgetExpiresCb.show();
					}
				},
				scope: this
			},
			items:[{
				boxLabel:t('Work'),
				inputValue: 1,
				checked:true
			},{
				boxLabel:t('Holiday'),
				inputValue: 2
			},{
				boxLabel:t('Absent'), // sickday
				inputValue: 3
			},{
				boxLabel: t("Special leave"),
				inputValue: 4
			}]
		},{
			name: 'name',
			xtype: 'textfield',
			fieldLabel: t("Name"),
			anchor: '100%',
			allowBlank:false
		},{
			name: 'units',
			fieldLabel: t("Default duration", "projects2"),
			xtype: 'numberfield',
			width: 200,
			allowBlank:false,
			suffix: t('Hours')
		},{
			name: 'description',
			xtype: 'textarea',
			fieldLabel: t("Description"),
			anchor: '100%',
			allowBlank:true
		},{
			xtype:'radiogroup',
			name: 'billable',
			value: 0,
			allowBlank:false,
			fieldLabel: t("Hours are billable"),
			items:[{
				boxLabel:t('No'),
				inputValue: 0,
				checked:true
			},{
				boxLabel:t('Yes'),
				inputValue: 1
			},{
				boxLabel:t('Always <br><small>(Also projects with fixed price)</small>'),
				inputValue: 2
			}]
		},this.budgetableCb = new Ext.form.Checkbox({
			name: 'budgetable',
			xtype: 'checkbox',
			boxLabel: t("Budgetable"),
			hideLabel: true,
			listeners: {
				check: function(cb, checked) {
					cb.nextSibling().setVisible(checked);
					// cb.nextSibling().nextSibling().setVisible(checked);
				}
			}
		}),this.budgetExpiresCb = new Ext.form.Checkbox({
			name: 'budgetExpires',
			xtype: 'checkbox',
			boxLabel: t("The budget expires"),
			hidden: false,
			hideLabel: true
		}),{
			name: 'budgetTransferable',
			xtype: 'checkbox',
			boxLabel: t("Remaining budget is transferable over years"),
			hidden: true, // This checkbox has been replaced by special leave budgets, i.e. activities with typeId 4
			hideLabel: true
		},{
			name: 'disabled',
			xtype: 'checkbox',
			boxLabel: t("Disabled"),
			hideLabel: true
		}]}];

	}

});
