Ext.define('go.modules.business.business.CategoryCombo', {
	extend: go.form.ComboBox,

	fieldLabel: t("Category"),
	hiddenName: 'categoryId',
	displayField : 'name',
	valueField: 'id',
	triggerAction: 'all',
	mode:'local',
	editable: true,
	selectOnFocus: true,
	forceSelection: true,
	allowBlank: true,
	initComponent: function() {
		if(!this.store) {
			this.store = new Ext.data.JsonStore({
				fields: ['id', 'name'],
				root: "records",
				autoDestroy: true
			});
		}
	},
	setBusiness :  function(business) {
		this.store.loadData({records: business.categories});
		var v = this.getValue();

		if(v)
			this.setValue(v); // for rendering text
	}
});

Ext.reg("categorycombo",go.modules.business.business.CategoryCombo);