<?php
namespace go\modules\business\catalog;

use Faker\Generator;
use go\core;
use go\modules\business\business\model\Business;
use go\modules\business\catalog\model\Article;

/**
 * @copyright (c) 2020, Intermesh BV https://www.intermesh.nl
 * @author System Administrat <admin@intermesh.localhost>
 * @license http://www.gnu.org/licenses/agpl-3.0.html AGPLv3
 */
class Module extends core\Module
{
	public function getAuthor() : string
	{
		return "Intermesh BV <info@intermesh.nl>";
	}

    /**
     * The development status of this module
     * @return string
     */
    public function getStatus() : string{
        return self::STATUS_STABLE;
    }

	public function autoInstall(): bool
	{
		return true;
	}

	public function requiredLicense(): ?string
	{
		return "billing";
	}

	public function demo(Generator $faker)
	{

		$article = Article::find()->where('number', '=', "100000")->single();
		if($article){
			return;
		}

		$business = Business::find()->single();
		$catCount = count($business->categories);

		$supplier = \go\modules\community\addressbook\Module::get()->demoCompany($faker);

		for($i = 0; $i < 10; $i ++) {

			$article = new Article();
			$article->businessId = $business->id;
			if($catCount) {
				$article->categoryId = $business->categories[mt_rand(0, $catCount - 1)]->id;
			}
			$article->name = $faker->text(20);
			$article->description = $faker->text(100);
			$article->vatRateId = $business->vatRates[0]->id;
			$article->number = "1" . str_pad($i,5, "0");
			$article->price = $faker->randomFloat(2, 1, 3000);
			$article->cost = $article->price / 2;
			$article->supplierOrganizationId = $supplier->id;
			$article->supplierNumber = "2" . str_pad($i * 2,5, "0");
			if(!$article->save()) {
				throw new core\orm\exception\SaveException($article);
			}
		}
	}

}
