go.modules.business.contracts.ContractDialog = Ext.extend(go.form.Dialog, {
	stateId: 'contracts-ContractForm',
	title: t("Contract"),
	entityStore: "Contract",
	width: dp(1100),
	height: dp(800),
	maximizable: true,
	collapsible: true,
	modal: false,
	titleField: "number",

	type: "contract", //use by FinanceDocumentItems

	initComponent: function() {
		this.supr().initComponent.call(this);

		this.formPanel.onBeforeLoad = async (entity)=> {

			await this.changeBook(entity.bookId, entity.businessModel);

			return entity;
		}
	},

	show : function() {
		if(!this.currentId) {
			if(this.bookCombo.getValue()) {
				this.changeBook(this.bookCombo.getValue()).then(() => {
					go.modules.business.contracts.ContractDialog.superclass.show.call(this);
				});
			} else {
				this.bookCombo.store.load().then(async () => {
					const first = this.bookCombo.store.getAt(0);
					if(!first) {
						Ext.MessageBox.alert(t("Warning"), t("You have no book setup yet"));
						go.modules.business.contracts.ContractDialog.superclass.show.call(this);
						return;
					}
					this.bookCombo.setValue(first.id);
					await this.changeBook(first.id, this.businessModel.getValue()).then(() => {
						go.modules.business.contracts.ContractDialog.superclass.show.call(this);
					})
				})
			}

		} else {
			go.modules.business.contracts.ContractDialog.superclass.show.call(this);
		}
	},

	onReady: function() {

		this.bookCombo.setDisabled(!!this.currentId);

		// add this after load and with a 20ms delay becuae Ext delays the check abd change events
		// for 10ms for some reason.
		setTimeout(() => {
			this.businessModel.on("change", (rg, businessModel) =>{
				this.changeBook(this.bookCombo.getValue(), businessModel.inputValue);
				this.selectCustomer.setValue(null);
				this.selectContact.setValue(null);
			})
		}, 500);

		go.modules.business.contracts.ContractDialog.superclass.onReady.call(this);

	},

	setLinkEntity: function (config) {
		switch (config.entity) {
			case  "FinanceDocument":

				const newItems = [];
				config.data.itemGroups.forEach(g => {
					g.items.forEach(i => {
						const copy = structuredClone(i);
						delete copy.id;
						newItems.push(copy);
					})
				})

				var v = {
					businessId: config.data.businessId,
					contactId: config.data.contactId,
					customerId: config.data.customerId,
					reference: config.data.reference,
					description: config.data.reference,
					items: newItems
				};

				this.on("ready", () => {
					this.setValues(v);
				}, this, {single: true})

				break;

			case 'Contact':
				if (config.data.isOrganization) {
					this.selectCustomer.setValue(config.entityId);
				} else {

					this.linkEntityId = config.entityId;

					this.selectContact.setValue(config.entityId);
					this.setCustomerFromContact(config.entityId);

				}
				break;

			case 'Project':

				if (config.data.company_id) {

					go.Db.store("Contact").single(config.data.company_id).then(org => {
						this.selectCustomer.setValue(org.id);

						if(config.data.contact_id) {
							this.selectContact.setValue(config.data.contact_id);
						}
					})


				} else if(config.data.contact_id) {
					this.selectContact.setValue(config.data.contact_id);
					this.setCustomerFromContact(config.data.contact_id);
				}
				break;
		}
	},

	changeBook: async function(bookId, businessModel) {
		if(!bookId) {
			return;
		}
		this.book = await go.Db.store("ContractBook").single(bookId);
		this.business = await go.Db.store("Business").single(this.book.businessId);
		const financeBook = await go.Db.store("FinanceBook").single(this.book.targetBookId);

		go.modules.business.finance.stores.vatRateStore.loadData({records: this.business.vatRates});
		go.modules.business.finance.ItemsField.prototype.vatRateId = this.business.vatRates[0].id;
		go.modules.business.finance.stores.categoryStore.loadData({records: this.business.categories});
		go.modules.business.finance.ItemsField.prototype.categoryCfg.hidden = this.business.categories.length === 0;

		this.businessModel.setVisible(financeBook.businessModel == 'both');
		if(!businessModel) {
			this.businessModel.setValue(financeBook.businessModel == 'both' ? 'b2b' : financeBook.businessModel);
			businessModel = financeBook.businessModel == 'both' ? 'b2b' : financeBook.businessModel
		}

		console.log(businessModel, this.financeItems.showPriceIncl);
		if(businessModel == "b2c" != this.financeItems.showPriceIncl) {
			this.financeItems.showPriceIncl = businessModel == "b2c";
			// if (this.rendered) {
				this.findByType("financeitemsfield").forEach((fi) => {
					fi.togglePriceIncl(this.financeItems.showPriceIncl);
				});
			// }
		}

		if(businessModel == "b2b") {

			if(this.linkEntityId) {
				this.selectContact.setValue(this.linkEntityId);
				this.setCustomerFromContact(this.linkEntityId);
			}
			this.selectContact.show();
			this.selectCustomer.setIsOrganization(true);
		} else
		{

			if(this.linkEntityId) {
				this.selectCustomer.setValue(this.linkEntityId);
			}

			this.selectContact.hide();
			this.selectCustomer.setIsOrganization(false);
		}


		this.financeItems.doLayout();

	},

	initFormItems: function () {


		this.addPanel({
			title: t("Advanced"),
			items: [{
				xtype: "fieldset",
				items: [{
					xtype: "datefield",
					fieldLabel: t("Next at"),
					name: "nextAt",
					hint: t("This date is normally configured automatically by the interval")
				},
					{
						xtype: "usercombo",
						fieldLabel: t("Owner"),
						hiddenName: "createdBy"
					}]
			}]
		});


		this.selectCustomer = new go.modules.community.addressbook.ContactCombo({
			anchor: '100%',
			fieldLabel: t("Customer"),
			hiddenName: 'customerId',
			isOrganization: undefined,
			allowBlank: false
		});

		var items = [{
			layout: "column",
			defaults: {
				labelAlign: "top"
			},
			items: [{
				columnWidth: .4,
				xtype: 'fieldset',
				items: [
					this.bookCombo = new go.modules.business.contracts.ContractBookCombo({
						anchor: "100%",
						listeners: {
							change: function (combo, bookId) {
								this.changeBook(bookId, this.businessModel.getValue());
							},
							scope: this
						}
					}),

					this.businessModel = new go.form.RadioGroup({
						hidden: true,
						hideMode: "offsets",
						anchor: '-20',
						xtype: 'radiogroup',
						fieldLabel: t("Business model"),
						name: "businessModel",
						value: null,

						items: [
							{
								boxLabel: t("B2B"),
								inputValue: 'b2b',

							},
							{
								boxLabel: t("B2C"),
								inputValue: 'b2c',

							}
						]

					}),

					this.selectContact = new go.modules.community.addressbook.ContactCombo({
						anchor: '-20',
						fieldLabel: t("Contact"),
						hiddenName: 'contactId',
						isCustomer: false,
						allowBlank: true,
						anchor: "100%",
					}),
					this.selectCustomer,

				{
						xtype: "textfield",
						fieldLabel: t("Reference"),
						name: "reference",
						anchor: "100%"
					}

				]
			}, {
				columnWidth: .6,
				xtype: "fieldset",
				items: [{
					layout: "column",
					xtype: "container",
					defaults: {
						xtype: "container",
						layout: "form"
					},
					items: [{
						columnWidth: .35,
						items: [{
							xtype: "hidden",
							name: "number"
						}, {
							xtype: "datefield",
							fieldLabel: t("Starts at"),
							name: "startsAt",
							value: new Date()
						}]
					}, {
						columnWidth: .35,
						items: [{
							xtype: "datefield",
							fieldLabel: t("Ends at"),
							name: "endsAt"
						}]
					}, {
						columnWidth: .3,
						items: [{
							xtype: "container",
							cls: "go-hbox",
							layout: "form",

							items: [
								{
									fieldLabel: t("Repeat every"),
									xtype: "gonumberfield",
									decimals: 0,
									value: 1,
									name: "intervalMonths",
									width: dp(100)
								},
								{
									xtype: "label",
									text: t("months"),
									style: "align-self: center"
								}]
						}]
					}
					]
				}, {
					xtype: "textfield",
					fieldLabel: t("Description"),
					name: "description",
					anchor: "100%"
				} , {
					xtype: "checkbox",
					boxLabel:  t("Automatically send invoice e-mail when creating"),
					name: "autoSend"
				}, {
					xtype: "checkbox",
					boxLabel:  t("Bill in arrears"),
					name: "billInArrears"
				}]
			}]
		}, this.createItemsFieldset()];

		this.selectContact.on('select', function (combo, record) {
			var me = this;

			me.setCustomerFromContact(record.data.id);
		}, this);

		return items;
	},

	setCustomerFromContact: function(id) {
		var me = this;
		go.Db.store("Contact").single(id).then(function (contact) {
			if (contact.organizationIds.length > 0) {
				me.selectCustomer.setValue(contact.organizationIds[0]);
			}
		});
	},

	createItemsFieldset: function () {

		this.financeItems = Ext.create({
			itemId: 'financeitemsfield',
			xtype: "financeitemsfield",
			decimals: go.Modules.get("business", "contracts").settings.decimals,
			showPriceIncl: false
		});

		return {
			title: t("Items"),
			xtype: "fieldset",
			items: [this.financeItems]
		};
	}
});
