/**
 * Copyright Intermesh
 *
 * This file is part of Group-Office. You should have received a copy of the
 * Group-Office license along with Group-Office. See the file /LICENSE.TXT
 *
 * If you have questions write an e-mail to info@intermesh.nl
 *
 * @copyright Copyright Intermesh
 * @author {authorName} <{email}>
 */

go.modules.business.contracts.MainPanel = Ext.extend(go.modules.ModulePanel,
	{
		id: "contracts",
		title: t("Contracts"),
		layout: 'responsive',
		layoutConfig: {
			triggerWidth: 1000
		},
		frontendConfig: {},

		initComponent: function () {
			this.frontendConfig = go.modules.business.contracts.ModuleConfig.frontendOptions;
			this.createContractGrid();

			this.ContractDetail = new go.modules.business.contracts.ContractDetail({
				region: 'center',
				split: true,
				tbar: [{
					cls: 'go-narrow', //will only show on small devices
					iconCls: "ic-arrow-back",
					tooltip: t("Contracts"),
					handler: function () {
						this.westPanel.show();
						go.Router.goto("contracts");
					},
					scope: this
				}]
			});

			// route to main grid when details resets / is deleted for mobile view
			this.ContractDetail.on("reset", () => {
				go.Router.goto("contracts");
			});

			this.sidePanel = new Ext.Panel({
				layout: "anchor",
				defaults: {
					anchor: "100%"
				},
				width: dp(300),
				cls: 'go-sidenav',
				region: "west",
				split: true,
				hidden: true,
				autoScroll: true,
				items: [
					this.createBookPanel(),
					this.createFilterPanel()
				]
			});

			this.westPanel = new Ext.Panel({
				region: "west",
				layout: "responsive",
				stateId: "go-contracts-west",
				split: true,
				width: dp(700),
				narrowWidth: dp(400), //this will only work for panels inside another panel with layout=responsive. Not ideal but at the moment the only way I could make it work
				items: [
					this.ContractGrid, //first is default in narrow mode
					this.sidePanel
				]
			});

			this.items = [
				this.westPanel //first is default in narrow mode
			];
			if (this.frontendConfig.showDetailPanel) {
				this.items.push(this.ContractDetail);
			}
			if (this.frontendConfig.showFilter) {
				this.sidePanel.show()
			}

			go.modules.business.contracts.MainPanel.superclass.initComponent.call(this);

			//use viewready so load mask can show
			this.ContractGrid.on("viewready", this.runModule, this);
		},
		runModule: function () {
			this.statusFilter.select(1, false, true);

			this.contractBookGrid.store.load();

		},


		setDue: function (count) {
			this.statusFilter.store.getAt(2).set("badge", count);
		},

		//
		// createBusinessPanel : function() {
		// 	this.documentBusinessGrid = new go.modules.business.catalog.BusinessGrid ({
		// 		region: "north",
		// 		autoHeight: true,
		// 		title: t("Business")
		// 	});
		// 	this.documentBusinessGrid.getSelectionModel().on('selectionchange', this.onFinanceBusinessSelectionChange, this, {buffer: 1}); //add buffer because it clears selection first
		//
		// 	return this.documentBusinessGrid;
		// },

		createBookPanel: function () {
			this.contractBookGrid = new go.modules.business.contracts.ContractBookGrid({
				tbar: [{
					xtype: 'tbtitle',
					text: t('Books')
				}, '->', {
					xtype: "tbsearch"
				}, {
					iconCls: 'ic-add',
					tooltip: t('Add'),
					handler: function (e, toolEl) {
						var dlg = new go.modules.business.contracts.ContractBookDialog();

						dlg.show();
					}
				},
					{
						cls: 'go-narrow',
						iconCls: "ic-arrow-forward",
						tooltip: t("Notes"),
						handler: function () {
							this.ContractGrid.show();
						},
						scope: this
					}],
				filterName: "bookId",
				filteredStore: this.ContractGrid.store,
				saveSelection: true,
				stateId: "contract-books",
				region: "north",
				autoHeight: true
			});
			this.contractBookGrid.getSelectionModel().on('selectionchange', this.onFinanceBookSelectionChange, this, {buffer: 1}); //add buffer because it clears selection first

			return this.contractBookGrid;
		},

		onFinanceBookSelectionChange: async function (sm) {

			var selected = sm.getSelected();
			if (!selected) {
				Ext.MessageBox.alert(t("No book", "There are no books defined yet in the system settings"));
				this.setDisabled(true);
			}

			go.modules.business.finance.business = selected.data;

			this.bookId = selected.id;

			this.addButton.setDisabled(!this.bookId || selected.data.permissionLevel < go.permissionLevels.write);
			this.moreBtn.setDisabled(!this.bookId || selected.data.permissionLevel < go.permissionLevels.write);
		},

		createFilterPanel: function () {

			this.statusFilter = new go.NavMenu({
				store: new Ext.data.ArrayStore({
					fields: ['name', 'icon', 'inputValue', "badge"], //icon and iconCls are supported.
					data: [
						[t("All"), 'star', null],
						[t("Active"), 'published_with_changes', true],
						[t("Due"), 'today', "due"],
						[t("Inactive"), 'unpublished', false]
					]
				}),
				simpleSelect: true,
				multiSelect: false,
				listeners: {
					selectionchange: function (view, nodes) {
						if (!nodes.length || nodes.length == 2) {
							this.ContractGrid.store.setFilter("active", null);
						} else {
							const record = view.store.getAt(nodes[0].viewIndex);

							if (record.data.inputValue == "due") {
								this.ContractGrid.store.setFilter("active", {active: true, nextAt: "< tomorrow"});
							} else {
								this.ContractGrid.store.setFilter("active", record.data.inputValue === null ? null : {active: record.data.inputValue});
							}
						}
						this.ContractGrid.store.load();
					},
					scope: this
				}
			});


			return new Ext.Panel({
				region: "center",
				minHeight: dp(200),
				autoScroll: true,
				tbar: [{
					xtype: 'tbtitle',
					text: t("Filters")
				},
					'->',
					{
						xtype: 'filteraddbutton',
						entity: 'Contract'
					}, {
						cls: 'go-narrow',
						iconCls: "ic-arrow-forward",
						tooltip: t("Contracts"),
						handler: function () {
							this.ContractGrid.show();
							go.Router.goto("contracts");
						},
						scope: this
					}],
				items: [
					this.statusFilter,
					{xtype: "box", autoEl: "hr"},

					this.filterGrid = new go.filter.FilterGrid({
						filterStore: this.ContractGrid.store,
						entity: "Contract"
					}), {
						xtype: 'variablefilterpanel',
						filterStore: this.ContractGrid.store,
						entity: "Contract"
					}
				]
			});
		},


		createContractGrid: function () {
			this.ContractGrid = new go.modules.business.contracts.ContractGrid({
				region: 'center',
				multiSelectToolbarItems: [
					{
						hidden: go.customfields.CustomFields.getFieldSets('Contract').length == 0,
						iconCls: 'ic-edit',
						tooltip: t("Batch edit"),
						handler: function () {
							var dlg = new go.form.BatchEditDialog({
								entityStore: "Contract"
							});
							dlg.setIds(this.ContractGrid.getSelectionModel().getSelections().column('id')).show();
						},
						scope: this
					}
				],
				tbar: [{
					cls: 'go-narrow', //Shows on mobile only
					iconCls: "ic-menu",
					handler: function () {
						this.sidePanel.show();
					},
					scope: this
				},
					'->',
					{
						xtype: 'tbsearch',
						hidden: !this.frontendConfig.showSearchBar
					},
					this.addButton = new Ext.Button({
						iconCls: 'ic-add',
						tooltip: t('Add'),
						disabled: !go.Modules.isAvailable("business", "contracts", go.permissionLevels.manage),
						cls: "primary",
						handler: function (btn) {
							var ContractForm = new go.modules.business.contracts.ContractDialog();
							ContractForm.setValues({
								bookId: this.bookId
							})
							ContractForm.show();
						},
						scope: this
					}),
					this.moreBtn = new Ext.Button({
						iconCls: 'ic-more-vert',
						menu: [this.reportBtn = new Ext.menu.Item({
							disabled: !go.Modules.isAvailable("business", "contracts", go.permissionLevels.manage),
							iconCls: "ic-show-chart",
							text: t("Report"),
							handler: function() {
								const win = new go.modules.business.contracts.ReportWindow();
								win.show();
								win.load(this.bookId);

							},
							scope: this
						})]
					})],
				listeners: {
					rowdblclick: this.onGridDblClick,
					scope: this,
					keypress: this.onGridKeyPress
				}
			});

			this.ContractGrid.on('navigate', function (grid, rowIndex, record) {
				go.Router.goto("Contract/" + record.id);
			}, this);
			if (this.frontendConfig.enableCSV) {
				this.moreBtn.menu.add('-', {
						iconCls: 'ic-cloud-upload',
						text: t("Import"),
						handler: function () {
							go.util.importFile(
								'Contract',
								'.csv,.xlsx',
								{
									businessId: this.businessId
								},
								{}
							);
						},
						scope: this
					},

					{
						text: t("Create due invoices now"),
						iconCls: "ic-today",
						scope: this,
						handler: async function () {

							this.getEl().mask(t("Saving..."));

							const oldRT = go.Jmap.requestTimeout;
							go.Jmap.requestTimeout = 180000;

							try {
								const response = await go.Jmap.request({
									method: "business/contracts/Contract/createInvoices",
									params: {
										bookId: this.bookId
									}
								})

								let msg = t("{count} invoices were created.").replace("{count}", response.count);

								if (response.errors.length) {
									msg += "<hr />" + t("There were {count} errors:").replace("{count}", response.errors.length) + "<br />" + response.errors.map((e) => Ext.util.Format.htmlEncode(e)).join("<br />");
								}

								Ext.MessageBox.alert(t("Create invoices"), msg);
							}
							catch(e) {
								GO.errorDialog.show(e);
							}
							finally {
								this.getEl().unmask();
								go.Jmap.requestTimeout = oldRT;
							}
						}
					},


					this.exportButton = new Ext.menu.Item({
						iconCls: 'ic-cloud-download',
						text: t("Export"),
						disabled: !go.Modules.isAvailable("business", "contracts", go.permissionLevels.manage),
						menu: [
							{
								text: 'Microsoft Excel',
								iconCls: 'filetype filetype-xls',
								handler: function () {
									go.util.exportToFile(
										'Contract',
										Object.assign(go.util.clone(this.ContractGrid.store.baseParams), this.ContractGrid.store.lastOptions.params, {
											limit: 0,
											position: 0
										}),
										'xlsx');
								},
								scope: this
							}, {
								text: 'Comma Separated Values',
								iconCls: 'filetype filetype-csv',
								handler: function () {
									go.util.exportToFile(
										'Contract',
										Object.assign(go.util.clone(this.ContractGrid.store.baseParams), this.ContractGrid.store.lastOptions.params, {
											limit: 0,
											position: 0
										}),
										'csv');
								},
								scope: this
							},
							{
								iconCls: 'filetype filetype-json',
								text: 'JSON',
								handler: function () {
									go.util.exportToFile(
										'Contract',
										Ext.apply(go.util.clone(this.ContractGrid.store.baseParams), this.ContractGrid.store.lastOptions.params, {
											limit: 0,
											start: 0
										}),
										'json');
								},
								scope: this
							}
						]
					}));
			}

			return this.ContractGrid;
		},
		onGridDblClick: function (grid, rowIndex, e) {
			var record = grid.getStore().getAt(rowIndex);
			if (!go.Modules.isAvailable("business", "finance") || record.get('permissionLevel') < go.permissionLevels.write) {
				return;
			}

			var dlg = new go.modules.business.contracts.ContractDialog();
			dlg.load(record.id).show();
		},

		onGridKeyPress: function (e) {
			if (e.keyCode != e.ENTER) {
				return;
			}
			var record = this.ContractGrid.getSelectionModel().getSelected();
			if (!record) {
				return;
			}

			if (record.get('permissionLevel') < go.permissionLevels.write) {
				return;
			}

			var dlg = new go.modules.business.contracts.ContractDialog();
			dlg.load(record.id).show();
		}
	});
