go.Modules.register("business", "finance", {
	// mainPanel: "go.modules.business.finance.MainPanel",
	title: t("Finance"),
	systemSettingsPanels: [
		"go.modules.business.finance.SystemSettingsPanel",
	],

	entities: [{
		name: "FinanceDocument",

		relations: {
			creator: {store: "UserDisplay", fk: "createdBy"},
			modifier: {store: "UserDisplay", fk: "createdBy"},
			customer: {store: "Contact", fk: "customerId"},
			contact: {store: "Contact", fk: "contactId"},
			book: {store: "FinanceBook", fk: "bookId"},
			status: {store: "FinanceDocumentStatus", fk: "statusId"}
		},
		filters: [{
			name: 'text',
			type: "string",
			multiple: false,
			title: t("Query")
		}, {
			title: t("Has links to..."),
			name: 'link',
			multiple: false,
			type: 'go.links.FilterLinkEntityCombo'
		},
			{
				title: t("Commented at"),
				name: 'commentedat',
				multiple: false,
				type: 'date'
			}, {
				title: t("Modified at"),
				name: 'modifiedat',
				multiple: false,
				type: 'date'
			}, {
				title: t("Modified by"),
				name: 'modifiedBy',
				multiple: true,
				type: 'string'
			}, {
				title: t("Created at"),
				name: 'createdat',
				multiple: false,
				type: 'date'
			}, {
				title: t("Created by"),
				name: 'createdby',
				multiple: true,
				type: 'string'
			}, {
				title: t("Date"),
				name: 'date',
				type: 'date',
				multiple: false
			},{
				title: t("Customer", "addressbook", "community") ,
				name: "customerId",
				type: "go.modules.community.addressbook.ContactCombo",
				typeConfig: {
					isOrganization: null
				}
			},{
				title: t("Article", "catalog", "business"),
				name: "articleId",
				type: "go.modules.business.catalog.ArticleCombo",
				multiple: true
			},{
				title: t("Subtotal"),
				name: "subtotal",
				type: "number",
				multiple: true
			}],
		links: [{
			title: t("Finance"),
			// filter: "quote",
			iconCls: 'entity ic-attach-money orange',
			linkWindow: function (entity, entityId) {
				return new go.modules.business.finance.SelectBookWindow();
			},
			linkDetail: function () {
				return new go.modules.business.finance.FinanceDocumentDetail();
			},
			linkDetailCards: function () {

				const quotes = new go.modules.business.finance.FinanceDocumentLinkDetail({
					title: t("Quotes"),
					type: "quote"
				});
				quotes.store.setFilter('type', {type: "quote"});

				const salesOrders = new go.modules.business.finance.FinanceDocumentLinkDetail({
					title: t("Open orders"),
					type: "salesorder"
				});
				salesOrders.store.setFilter('type', {type: "salesorder"});

				const incomplete = new go.modules.business.finance.FinanceDocumentLinkDetail({
					title:  t("Open invoices"),
					type: "salesinvoice"
				});
				incomplete.store.setFilter('completed',{complete:  false, type: "salesinvoice"});

				const completed = new go.modules.business.finance.FinanceDocumentLinkDetail({
					title:  t("Paid invoices"),
					type: "salesinvoice"
				});
				completed.store.setFilter('completed',{complete:  true, type: "salesinvoice"});


				const purchaseOrders = new go.modules.business.finance.FinanceDocumentLinkDetail({
					title: t("Purchase orders"),
					type: "purchaseorder"
				});
				purchaseOrders.store.setFilter('type', {type: "purchaseorder"});


				const purchaseInvoices = new go.modules.business.finance.FinanceDocumentLinkDetail({
					title: t("Purchase invoices"),
					type: "purchaseinvoice"
				});
				purchaseInvoices.store.setFilter('type', {type: "purchaseinvoice"});

				return [
					quotes,
					salesOrders,
					incomplete,
					completed,
					purchaseOrders,
					purchaseInvoices
				];
			}
		}]
	}, {
		name: "DebtorProfile"
	}, {
		name: "Payment",
		relations: {
			customer: {store: "Contact", fk: "customerId"},
			document: {store: "FinanceDocument", fk: "documentId"},
			business: {store: "Business", fk: "businessId"}
		},
	}, {
		name: "FinanceBook",
		relations: {
			business: {store: "Business", fk: "businessId"}
		}
	}, {
		name: "Debtor",
		relations: {
			business: {store: "Business", fk: "businessId"},
			customer: {store: "Contact", fk: "contactId"},
		}
	}],
	initModule: function () {

		async function showBadge() {
			const count = await go.Jmap.request({method: "Debtor/countActions"});
			GO.mainLayout.setNotification('finance', count,'orange');

			GO.mainLayout.getModulePanel("finance", false).setDebtorActions(count);
		}


		GO.mainLayout.on("authenticated", () => {

			if(!go.Modules.isAvailable("business", "finance")) {
				return;
			}
			if(!go.Modules.isAvailable("business", "business")) {
				GO.errorDialog.show(t("The finance module requires access to the business module too. Please grant this permission."));
				return;
			}
			this.addPanel([
				go.modules.business.finance.MainPanel
			]);

			if(go.Modules.isAvailable("business", "finance")) {
				showBadge();
			}
		})

	}
});

go.modules.business.finance.util = {

	humanType : function(type) {
		go.Translate.setModule("business", "finance");

		let title;
		switch(type) {
			case 'quote':
				title = t("Quote");
				break;
			case 'salesorder':
				title = t("Sales order");
				break;
			case 'salesinvoice':
				title = t("Sales invoice");
				break;
			case 'purchaseorder':
				title = t("Purchase order");
				break;
			case 'purchaseinvoice':
				title = t("Purchase invoice");
				break;
		}

		return title;
	},

	humanStatus : function(id, book) {

		go.Translate.setModule("business", "finance");
		switch(id) {
			case "draft":
				return book.type == "salesorder" ? t("New") : t("Draft");

			case "ready":
				return t("Ready for delivery");

			case "cancelled" :
				return book.type == "quote" ? t("Rejected") : t("Cancelled");

			case "sent":
				return t("Sent");

			case "accepted":
				return t("Accepted");

			case "complete":
				return book.type == "salesinvoice" || book.type == "purchaseinvoice" ? t("Paid") : t("Complete");

			case "late":
				return t("Late");
				break;

			default:

				const status = book.statuses.find((s) => {
					return s.id == id;
				});

				return status ? status.name : id;
		}
	},

	getStatusBadge: function(doc, cls, book) {

		let id = doc.status;

		if (parseInt(doc.status) == doc.status) {
			const status = book.statuses.find((s) => {
				return s.id == doc.status;
			});

			if (status) {
				return '<div class="status" style="background-color: #' + status.color + '">' + status.name + '</div>';
			}
		}

		if(!cls)
		{
			cls = "";
		}
		return '<div class="status business-finance-document-status-' + id + ' ' + cls + '">' + this.humanStatus(id, book) + '</div>';
	}
};

go.modules.business.finance.stores = {

	vatRateStore: new Ext.data.JsonStore({
		fields: ['id', 'name', 'rate', 'enabled'],
		root: "records",
		autoDestroy: false
	}),

	categoryStore: new Ext.data.JsonStore({
		fields: ['id', 'name'],
		root: "records",
		autoDestroy: false
	}),


	status: new go.modules.business.finance.StatusStore(),
	types: new Ext.data.ArrayStore({
		autoDestroy: false,
		xtype: "arraystore",
		fields: [
			'value',
			'display'
		],
		id: 0,
		data: [
			['quote', t('Quotes')],
			['salesorder', t('Sales orders')],
			['purchaseorder', t('Purchase orders')],
			['purchaseinvoice', t('Purchase invoices')],
			['salesinvoice', t('Sales invoices')]
		]
	})
};


