go.modules.business.finance.StatusStore = Ext.extend(Ext.data.ArrayStore, {

	constructor : function(config) {
		config = config || {};
		config.fields = [
			'id',
			'name',
			'custom',
			'color'
		];
		config.data = [
			['draft'],
			['sent'],
			['accepted'],
			['cancelled'],
			['late'],
			['complete']
		];
		config.id = 0;

		go.modules.business.finance.StatusStore.superclass.constructor.call(this, config);
	},
	loaded: true, //for jsonmenu
	loadStatuses: function(book, setableOnly) {

		this.clearFilter();

		// remove previously added statuses
		if(this.customStatusRecords) {
			this.customStatusRecords.forEach(r => {
				this.remove(r);
			})
		}

		if(book.statuses.length) {
			const data = [];
			book.statuses.forEach(s => {
				data.push([s.id, s.name, true, s.color]);
			});
			const r = this.reader.readRecords(data);

			this.insert(5, r.records);

			this.customStatusRecords = r.records;
		} else {
			this.customStatusRecords = [];
		}

		this.getRange().forEach(r => {
			r.set("name", go.modules.business.finance.util.humanStatus(r.data.id, book));
		});

		this.filterBy((record) => {
			switch(record.id) {

				case 'draft':
					return !setableOnly;

				case 'late':
					return !setableOnly && book.type != "salesorder";

				case "accepted":
					return book.type == "salesorder" || book.type == "quote";
					break;

				case 'cancelled':
					return book.type == "salesorder" || book.type == "quote";

				default:
					return true;
			}
		});


	},


	autoDestroy: false

});