go.modules.business.studio.CreateModuleDialog = Ext.extend(go.form.Dialog, {
	title: t('Create a Module', 'studio', 'business'),
	entityStore: "Studio",
	width: 1024,
	height: 768,
	doRedirect: false,
	initComponent: function () {

		this.saveButton = new Ext.Button({
			text: t("Save"),
			handler: this.save,
			scope: this
		});
		this.buttons = [
			'->',
			this.saveButton
		];
		go.modules.business.studio.CreateModuleDialog.superclass.initComponent.call(this);
	},

	initFormItems: function () {
		this.modulePanel = new go.modules.business.studio.CreateModulePanel({
			hideMode: 'offsets',
		});
		this.tabPanel = new Ext.Panel({
			layout: 'card',
			anchor: "100% 100%",
			defaults: {
				autoScroll: true
			},
			items: [
				this.modulePanel
			]
		});
		return [this.tabPanel];
	},

	show: function () {
		go.modules.business.studio.CreateModuleDialog.superclass.show.call(this);
		this.tabPanel.getLayout().setActiveItem(0);
	},


	validateComponent: function (cmp) {
		let validateSuccess = true;

		if (cmp.items && cmp.items.length && !(cmp.isFormField && !cmp.isComposite && cmp.getXType() !== 'checkboxgroup')) {
			cmp.items.each(function (item) {

				if (item.disabled) {
					return true;
				}

				validateSuccess = this.validateComponent(item);
				if (!validateSuccess) {
					return false;
				}
			}, this);
		} else {
			if (cmp.activeError) {
				validateSuccess = false;
			} else {
				validateSuccess = cmp.isValid ? cmp.isValid() : true;
			}
		}

		return validateSuccess;
	},

	save: function () {
		if (!this.validateComponent(this.tabPanel.getLayout().activeItem)) {
			return;
		}
		const form = this.modulePanel.findParentByType('form');
		const values = form.getValues();
		const packageName = values.module.package || "studio", moduleName = values.module.name,
			moduleDescription = values.module.description;

		let params = {
			module: moduleName,
			package: packageName,
			description: moduleDescription,
			moduleType: values.module.moduleType,
			entity: values.entity.name,
			doOverwrite: true
		};
		if(values.itemEntity) {
			params.itemEntity = values.itemEntity.name;
		}
		go.Db.store("Studio").set({
			create: {
				s: {
					configurationParams: params,
					description: moduleDescription,
					name: packageName + "-" + moduleName,
					package: packageName,
					locked: true
				}
			}
		}).then( async (response) => {
			if(!response.created.s) {
				throw(t("Unable to create module folder. If you enabled debugging, please check your GroupOffice log.",
					"studio", "business"));
			}
			const r =  response.created.s;

			// Redirect to studio wizard and force a hard reload
			go.Router.setPath('/studio/'+r.id+ '/module/'+r.moduleId);
			window.location.replace(window.location.pathname +  window.location.hash)
			window.location.reload(true);
			this.hide();

		}).catch((reason) => {
			let reasonStr = reason;
			if(Ext.isObject(reason) && reason.message) {
				reasonStr = reason.message;
			} else if(Ext.isArray(reason)) {
				if(reason[0] === "error") {
					reasonStr = reason[1].message;
				}
			}
			Ext.Msg.show({
				title: t('Group Office Studio'),
				msg: reasonStr,
				ok: true
			});
		});
	}
});
