create table business_support_email_account
(
    accountId  int              not null,
    tasklistId int(11) unsigned not null,
    primary key (accountId),
    constraint business_support_email_account_em_accounts_id_fk
        foreign key (accountId) references em_accounts (id)
            on delete cascade,
    constraint business_support_email_account_tasks_tasklist_id_fk
        foreign key (tasklistId) references tasks_tasklist (id)
            on delete cascade
);

create table business_support_settings
(
    id                int unsigned not null,
    defaultTaskListId int unsigned null,
    taskUrlTemplate TEXT null comment 'The URL to open a task for the customer. {id} can will be replaced with the ID of the task.',
    `expireDays` INT UNSIGNED NOT NULL DEFAULT 0,
    `sendExpireFeedback` ENUM('none', 'private', 'public') DEFAULT 'none',
    `expiryText` TEXT NULL DEFAULT NULL,
    `excludeCategories` VARCHAR(191) NULL DEFAULT NULL,
    `excludeLists` VARCHAR(191) NULL DEFAULT NULL,
    primary key (id),
    constraint business_support_settings_tasks_tasklist_id_fk
        foreign key (defaultTaskListId) references tasks_tasklist (id)
            on delete set null
);

create table business_support_user_settings
(
    userId            int                  not null,
    defaultTasklistId int(11) unsigned     null,
    rememberLastItems tinyint(1) default 0 not null,
    lastTasklistIds   varchar(255)         null,
    primary key (userId),
    constraint business_support_user_settings_core_user_id_fk
        foreign key (userId) references core_user (id)
            on delete cascade,
    constraint business_support_user_settings_tasklist_id_fk
        foreign key (defaultTasklistId) references tasks_tasklist (id)
            on delete set null
);

create table business_support_tasklist
(
    taskListId    int unsigned not null,
    customerAclId int          null,
    primary key (taskListId),
    constraint business_support_tasklist_core_acl_null_fk
        foreign key (customerAclId) references core_acl (id),
    constraint business_support_tasklist_tasks_tasklist_null_fk
        foreign key (taskListId) references tasks_tasklist (id)
            on delete cascade
);

create table business_support_ticket_custom_fields
(
    id          int(11) unsigned        not null
        primary key,
    constraint fk_business_support_ticket_custom_fields1
        foreign key (id) references tasks_task (id)
            on delete cascade
);

create table business_support_ticket
(
    id int unsigned not null,
    cc text null,
    constraint business_support_ticket_pk
        primary key (id),
    constraint business_support_ticket_tasks_task_id_fk
        foreign key (id) references tasks_task (id)
            on delete cascade
);