GO.documenttemplates.TemplateDocumentDialog = function(config){

	config=config || {};

	config.title=t("Document from template", "documenttemplates");
	config.width=600;
	config.height=600;
	config.closeAction='hide';
	config.layout='border';
	config.keys=[{
		key:Ext.EventObject.ENTER,
		fn:function(key, e){
			if(e.target.id!=this.searchField.id){
				this.createFileFromTemplate();
			}
		},
		scope:this
	}];

	config.defaults = {margins:'0 0 5 0'}


	var checkCol = new GO.grid.RadioColumn({
		header: '',
		dataIndex: 'checked',
		width: 55,
		onMouseDown : function(col, grid, rowIndex, e) {
			if (e.target.className.indexOf('x-grid3-radio-col') > -1) {
				e.stopEvent();

				var record = grid.store.getAt(rowIndex);
				var disabled = this.isDisabled(record);

				if (!disabled) {
					if (record.get(this.dataIndex)) {
						return;
					}

					for (var i = 0, max = grid.store.getCount(); i < max; i++) {
						var rec = grid.store.getAt(i);
						if (rec.get(this.dataIndex) && rec.get('model_name') == record.get('model_name')) {
							rec.set(this.dataIndex, false);
						}

					}
					record.set(this.dataIndex, true);
				}
			}
		}
	});
	var columnModel = new Ext.grid.ColumnModel({
		defaults:{
			sortable:true
		},
		columns:[
		checkCol,
		{
			header: t("Name"),
			dataIndex: 'name',
			renderer:function(v, meta, record){
				return '<div class="go-grid-icon go-model-icon-'+record.data.model_name+'">'+v+'</div>';
			}
		},
		{
			header: t("Type"),
			dataIndex: 'model_name',
			renderer: function(v, meta, record) {
				
				var entity = v.split("\\").pop();
				
				return t(entity, go.Entities.get(entity).module);
			}
		}
		]
	});

	var f;
	f = this.formPanel = new Ext.form.FormPanel({
		region:'north',
		autoHeight:true,
		cls:'go-form-panel',
		items:[{
			xtype:'textfield',
			name:'name',
			fieldLabel:t("Name", "files"),
			allowBlank:false,
			anchor:'100%'
		},{
			xtype:'compositefield',
			items:[
				this.pathField = new Ext.form.TextField({
					fieldLabel: t("Folder", "files"),
					name: "path",
					readOnly:true,
					id: "path",
					value: '',
					flex      : 1
				}),this.selectFolderBtn =  new Ext.Button({
					xtype: 'button',
					iconCls: 'folder-default',
					hideLabel: true,
					text: t('Browse', 'files'),
					handler: function () {
						this.selectFolder();
					},
					scope: this
				})
			]
		},{
			xtype: 'hidden',
			name: 'files_folder_id'
		}]
	});

	config.focus = function(){
		f.form.findField('name').focus();
	};

	this.searchField = new GO.form.SearchField({
		store: GO.documenttemplates.ooTemplatesStore,
		width: 200
	});

	this.templatesGrid = new GO.grid.GridPanel({
		region:'center',
		cls: "go-grid3-hide-headers",
		tbar: [{xtype:'tbtitle', text:t("Select document template", "documenttemplates") },"->", t("Search") + ':', this.searchField],
		listeners:{
			scope:this,
			delayedrowselect: function(grid, rowIndex, r){
				this.formPanel.getForm().findField('name').setValue('');
				this.loadAmbiguousLinksGrid();
			}
		},
		viewConfig: {
			autoFill: true,
			forceFit: true,
			emptyText: t("No items to display"),
			afterRender: function(){
				this.constructor.prototype.afterRender.apply(this, arguments);
				this.grid.getSelectionModel().selectFirstRow();
			}
		},
		store:GO.documenttemplates.ooTemplatesStore,
		sm: new Ext.grid.RowSelectionModel({
			singleSelect:true
		}),
		columns:[{
			header: t("Name"),
			dataIndex: 'name',
			sortable:true
		},
		{
			header: t("Type"),
			dataIndex: 'type' ,
			renderer: this.typeRenderer.createDelegate(this),
			width: 100,
			sortable:false
		}]
	});
	
	


	this.ambiguousLinksGrid = new GO.grid.GridPanel({
		cls: "go-grid3-hide-headers",		
		region:'south',
		height:240,
		split:true,
		title:t("Select relevant resources", "documenttemplates"),
		store:new Ext.data.GroupingStore({
			url: GO.url("documenttemplates/document/getLinks"),
			reader: new Ext.data.JsonReader({
				root: 'results',
				id: 'model_name_and_id',
				fields: ['model_name_and_id','name', 'checked', 'model_name']
			}),
			groupField:'model_name',
			remoteSort:true
		}),
		paging:false,
		plugins:checkCol,
		cm:columnModel,
		view:new Ext.grid.GroupingView({
			hideGroupedColumn:true,
			groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "'+t("items")+'" : "'+t("item")+'"]})',
			emptyText: t("No items to display"),
			showGroupName:false
		}),
		autoExpandColumn:1,
		loadMask:true
	});

	config.items=[this.formPanel, this.templatesGrid, this.ambiguousLinksGrid];
	config.buttons=[{
			text:t("Ok"),
			handler:function(){
				this.createFileFromTemplate();
			},
			scope:this
	}];

	this.templatesGrid.on('render', function() { 
		GO.documenttemplates.ooTemplatesStore.load();
	}, this);


	// Moved to Ext.extend below... in order to enable overrides
	// this.selectFolder = function () {
	// 	var fileFolderField = this.formPanel.getForm().findField('files_folder_id');
	// 	var pathField = this.formPanel.getForm().findField('path');
	// 	var folderId = fileFolderField.getValue();
	// 	if (!this.selectFolderDialog) {
	// 		this.selectFolderDialog = new GO.files.SelectFolderDialog({
	// 			handler: function (fs, path, fullResponse) {
	// 				fileFolderField.setValue(fullResponse.id);
	// 				pathField.setValue(path);
	// 				this.selectFolderDialog = null;
	// 			}
	// 		});
	// 		this.selectFolderDialog.foldersTree.getLoader().baseParams.root_folder_id = folderId;
	// 		this.selectFolderDialog.foldersTree.getLoader().baseParams.expand_folder_id = this.folderId || folderId;
	// 		// this.selectFolderDialog.foldersTree.setExpandFolderId(fileFolderField.getValue());
	// 	}
	//
	// 	this.selectFolderDialog.show();
	// };
	this.setDefaultFolder = function() {
		var fileFolderField = this.formPanel.getForm().findField('files_folder_id');
		var pathField = this.formPanel.getForm().findField('path');
		var me = this;
		GO.request({
			url: 'files/folder/checkModelFolder',
			jsonData: {},
			params: {
				mustExist: true,
				returnPath: true,
				model: this.entity,
				id: this.entityId
			},
			success: function (response, options, result) {
				me.rootFolderId = result.files_folder_id;
				fileFolderField.setValue(result.default_folder_id || result.files_folder_id);
				pathField.setValue(result.path);
			}
		});
	}

	GO.documenttemplates.TemplateDocumentDialog.superclass.constructor.call(this, config);
}

Ext.extend(GO.documenttemplates.TemplateDocumentDialog, GO.Window,{

	entityId:0,
	entity:0,
	rootFolderId: 0,
	
	show : function(){
	
		
		if(this.rendered){
			this.loadAmbiguousLinksGrid();
		}
		
		GO.documenttemplates.TemplateDocumentDialog.superclass.show.call(this);
		this.setDefaultFolder();

		this.formPanel.form.reset();
	},

	templateType : {
		'0' : 'E-mail',
		'1' : t("Document template", "documenttemplates")
	},

	typeRenderer : function(val, meta, record)
	{
		var type = this.templateType[val];

		if(val=='1'){
			type+=' ('+record.get('extension')+')';
		}

		return type;
	},

	setFilename: function(r, model) {
		var field = this.formPanel.getForm().findField('name');
		if(Ext.isEmpty(field.getValue())) {
			if(!Ext.isEmpty(r.json.filename)) {
				field.setValue(this.parseTemplate(r.json.filename, model.json));
			} else {
				field.setValue('');
			}
		}
	},

	parseTemplate: function(tpl, obj) {
		with(obj) {
			return eval('`' + tpl.replace(/{/g, '${') + '`');
		}
	},

	loadAmbiguousLinksGrid : function() {
		var record = this.templatesGrid.getSelectionModel().getSelected();
		if(!record) {
			return;
		}
		var params = {
			template_id: record.id,
			model_name:this.entity,
			model_id:this.entityId
		};
		
		this.ambiguousLinksGrid.store.load({
			callback:function(){
				this.ambiguousLinksGrid.setDisabled(false);
				var records = this.ambiguousLinksGrid.store.getRange();
				for(var i=0,max=records.length;i<max;i++){
					if(records[i].get('model_name').split('\\').pop() == this.entity && records[i].id.split(':').pop() == this.entityId) {
						this.setFilename(record, records[i]);
					}
				}
			},
			scope:this,
			params:params
		});
	},
	createFileFromTemplate : function() {
		var templateRecord = this.templatesGrid.getSelectionModel().getSelected();

		if(!templateRecord) {
			Ext.MessageBox.alert(t("Error"), t("Please select a template from the list"));
			return;
		}
						
		var params = {
			template_id: templateRecord.id,
			model_name: this.entity,
			model_id: this.entityId,
			filename: this.formPanel.form.findField('name').getValue().trim(),
			files_folder_id: this.formPanel.form.findField('files_folder_id').getValue()
		};
		
		if(params.filename=='') {
			this.formPanel.form.findField('name').focus();
			return;
		}

		var records = this.ambiguousLinksGrid.store.getRange();
		var links=[];
		for(var i=0,max=records.length;i<max;i++){
			if(!GO.util.empty(records[i].get('checked'))){
				links.push(records[i].get('model_name_and_id'));
			}
		}
		params.selectedLinks=Ext.encode(links);
		
		GO.request({
			params:params,
			url:'documenttemplates/document/create',
			success: function(response, options, result){
				
				GO.files.openFile({id: result.file_id});
				
				this.hide();
				//defer was necessary for chrome. Otherwise it the reloading of the panel gave a connection error.
				this.fireEvent.defer(300,this,['create', this, result.file_id]);
				
			},
			scope:this
		})
	},
	selectFolder: function () {
		var fileFolderField = this.formPanel.getForm().findField('files_folder_id');
		var pathField = this.formPanel.getForm().findField('path');
		var folderId = fileFolderField.getValue();
		//var reload = false;
		if (!this.selectFolderDialog) {
			this.selectFolderDialog = new GO.files.SelectFolderDialog({
				handler: function (fs, path, fullResponse) {
					fileFolderField.setValue(fullResponse.id);
					pathField.setValue(path);
				}
			});
			this.selectFolderDialog.foldersTree.getLoader().addListener('load', function(loader, node, response){
				var folderId = this.formPanel.getForm().findField('files_folder_id').getValue();
				var defaultFolderNode = node.findChild('id', folderId, true);
				if(defaultFolderNode) {
					this.selectFolderDialog.foldersTree.getSelectionModel().select(defaultFolderNode);
				}
			},this);
		}
		this.selectFolderDialog.foldersTree.getLoader().baseParams.root_folder_id = this.rootFolderId;
		this.selectFolderDialog.foldersTree.getLoader().baseParams.expand_folder_id = folderId;


			//reload = true;


		//if(reload) {
		this.selectFolderDialog.foldersTree.getRootNode().reload();
		//}

		this.selectFolderDialog.show();
	}

});
