GO.leavedays.SpecialLeaveBudgetGrid = Ext.extend(GO.grid.GridPanel, {

	initComponent: function () {
		this.msgWindow = new Ext.Window({
			title: t("Reason why", "leavedays"),
			width: 400,
			height: 260,
			layout: 'form',
			modal: false,
			resizable: false,
			closeAction: 'hide',
			items: [
				new Ext.form.FormPanel({
					hideLabels: true,
					cls:'go-form-panel',
					items: [{
						xtype:'textarea',
						id:'ld-reason-why',
						name: 'comment',
						height: 155,
						anchor: '100%'
					}]
				})
			],
			listeners: {
				show: function() {
					Ext.getCmp('ld-reason-why').focus(true, 100);
				},
				scope: this
			},
			buttons: [
				this.msgWindowSend = new Ext.Button({
					text: t('Send'),
					iconCls: 'ic-send',
					handler: function(){
						this.msgWindow.onSend(this.msgWindow);
						this.msgWindow.hide();
					},scope:this
				})
			],
			onSend: function(scope) {},
			onHide: function() {
				if(!this.switchbackRadio) {
					return;
				}
				this.switchbackRadio.setValue(true);
				Ext.getCmp('ld-reason-why').setValue('');
			}
		});

		this.addButton = new Ext.Button({
			iconCls: 'ic-add',
			text: t("Add"),
			handler: function () {
				let id = 0, config = {};
				// if(GO.leavedays.currentUserIsManager) {
					config["loadParams"] = {agreement_id : GO.leavedays.activeAgreementId};
				// }
				GO.leavedays.showSpecialLeaveDialog(id, config);

				if (!this.saveListenerAdded) {
					this.saveListenerAdded = true;
					GO.leavedays.specialLeaveDialog.on('save', function () {
						this.store.load();
						this._loadYearSummary();
					}, this);
				}
			},
			scope: this
		});
		this.delButton = new Ext.Button({
			iconCls: 'ic-delete',
			text: t("Delete"),
			handler: () => {
				this.deleteSelected();
			},
			scope: this
		});

		this.view = new Ext.grid.GridView({
			emptyText: t("No items to display")
		});

		let columns = [{
			header: t('First date'),
			dataIndex: 'start_date',
			xtype: 'datecolumn',
			format: GO.settings.date_format,
			dateOnly: true,
		}, {
			header: t('Last date'),
			dataIndex: 'finish_date',
			xtype: 'datecolumn',
			format: GO.settings.date_format,
			dateOnly: true,
		}, {
			header: t('Type'),
			dataIndex: 'credit_type'
		}, {
			header: t('Budgeted'),
			dataIndex: 'n_hours',
			align: "right"
		}, {
			header: t('Spent'),
			dataIndex: 'spent_hours',
			align: "right",
			renderer: function (v) {
				return go.util.Format.number(v, 2);
			}
		}, {
			id: 'description',
			header: t("Description"),
			dataIndex: 'description'
		}];

		const icons = {
			appr: '<i class="icon">check</i>',
			disa: '<i class="icon">clear</i>',
			none: '<i class="icon">warning</i>'
		};

		if (GO.leavedays.currentUserIsManager) {

			const radioRenderer = function (value, meta, r, row, col) {
				let managerUserIds = [];
				const muid = r.get('manager_user_id');
				if (typeof muid === 'number') {
					managerUserIds.push(muid);
				} else if (typeof muid === 'string') { // In theory, an employee has more managers as per 6.5-ish
					managerUserIds = muid.split(',');
				}

				// This is a slight TODO
				if (managerUserIds.indexOf(GO.settings.user_id) === -1 && !GO.settings.modules.leavedays.write_permission) {
					// return '';
				}
				const id = Ext.id();
				Ext.defer(function () {
					new Ext.form.Radio({
						renderTo: id,
						name: 'ld-status-' + row,
						checked: r.get('status') === columns[col].emptyGroupText,
						width: 75,
						handler: function (me, checked) {
							if (!checked) {
								this.msgWindow.switchbackRadio = me;
								return;
							}

							this.msgWindow.onSend = function (scope) {

								GO.request({
									url: 'leavedays/specialleavebudget/update',
									params: {
										id: r.id,
										// user_id: r.data.user_id,
										status: columns[col].emptyGroupText,
										reasonWhyMsg: Ext.getCmp('ld-reason-why').getValue()
									},
									success: function () {
										Ext.getCmp('ld-reason-why').setValue('')
									}
								});
								scope.switchbackRadio = null;
							};

							if (columns[col].emptyGroupText == 2) {
								this.msgWindow.show();

							} else {
								GO.request({
									url: 'leavedays/specialleavebudget/update',
									params: {
										id: r.id,
										// user_id: r.data.user_id,
										status: columns[col].emptyGroupText
									},
									scope: this,
									success: function (response, options, result) {
										this.store.reload();
									},
									fail: function (response, options, result) {
										Ext.MessageBox.alert(t('Warning'), t(result.data.feedback));
										this.store.reload();
									}
								});
							}
						},
						scope: this
					});
				}, 50, this);
				return String.format('<div id="{0}"></div>', id);
			};


			columns.push({
				header: icons['appr'],
				width: dp(64),
				style: {
					"overflow": "visible"
				},
				emptyGroupText: 1, //abusing this property to pass value to radio select
				sortable: false,
				hideable: false,
				menuDisabled: true,
				resizable: false,
				renderer: {
					fn: radioRenderer,
					scope: this
				}
			}, {
				header: icons['disa'],
				width: dp(64),
				emptyGroupText: 2,
				sortable: false,
				hideable: false,
				menuDisabled: true,
				resizable: false,
				renderer: {
					fn: radioRenderer,
					scope: this
				}
			}, {
				header: icons['none'],
				width: dp(64),
				emptyGroupText: 0,
				sortable: false,
				hideable: false,
				menuDisabled: true,
				resizable: false,
				renderer: {
					fn: radioRenderer,
					scope: this
				}
			});
		} else {
			columns.push({
				header: t("Status"),
				renderer: function (v, meta, record) {

					if (record.get('status') == 0) {
						return '';
					}
					if (record.get('status') == 1) {
						return icons['appr'];
					}
					if (record.get('status') == 2) {
						return icons['disa'];
					}
				}
			});
		}
		this.tbar = [this.addButton, this.delButton];
		Ext.apply(this, {
			plugins: this.checkColumn ? this.checkColumn : [],
			border: false,
			title: t("Special leave budgets", "leavedays"),
			layout: "fit",
			autoScroll: true,
			cm: new Ext.grid.ColumnModel({
				defaultSortable: true,
				columns: columns

			}),
			scope: this
		});

		this.store = new GO.data.JsonStore({
			url: GO.url('leavedays/specialleavebudget/store'),
			baseParams: {
				user_id: GO.leavedays.activeUserId,
				year: GO.leavedays.activeYear
			},
			remoteSort: true,
			fields: ['id', 'description', 'start_date', 'finish_date', 'n_hours', 'spent_hours', 'credit_type', 'status', 'agreement_id'],
			scope: this,
			root: 'results',
			forceFit: true,
			id: 'id',
			totalProperty: 'total',
			sm: new Ext.grid.RowSelectionModel(),
			loadMask: true,
			clicksToEdit: 1
		});

		this.on('rowdblclick', function (grid, rowIndex, event) {
			const record = grid.store.getAt(rowIndex);

			if (record.get('status') != 0 && !GO.settings.modules.leavedays.write_permission) {
				return false;
			}
			GO.leavedays.showSpecialLeaveDialog(record.data['id']);

			if (!this.saveListenerAdded) {
				this.saveListenerAdded = true;
				GO.leavedays.specialLeaveDialog.on('save', function () {
					this.store.load();
					this._loadYearSummary();
				}, this);
			}

		}, this);

		GO.leavedays.SpecialLeaveBudgetGrid.superclass.initComponent.call(this);
	},

	_loadYearSummary: function () {
		const p = this.findParentByType('module-main-leavedays');
		if (p && p.userPanel.summaryPanel.rendered) {
			const sp = p.userPanel.summaryPanel;
			sp.load({
				url: GO.url('leavedays/leaveday/yearInfo'),
				params: {
					'userId': GO.leavedays.activeUserId,
					'selectedYear': GO.leavedays.activeYear
				}
				, scope: this
				, callback: function (panel, success, action) {

					if (typeof (this.addButton) == 'object') {
						this.addButton.setDisabled(GO.util.empty(action.responseText));
					}
					if (typeof (this.delButton) == 'object') {
						this.delButton.setDisabled(GO.util.empty(action.responseText));
					}
				}
			});
		}
	}
});