import { AutocompleteField } from "./AutocompleteField";
import { datasourcestore, } from "../../data";
import { column, table } from "../table";
import { createComponent } from "../Component";
import { Format } from "../../util";
export const ComboBoxDefaultRenderer = (field, r) => r[field.displayProperty];
/**
 * Combo box
 *
 * An extension of the Autocomplete field that simplifies the creation of a simple combobox with a
 * valueProperty and displayProperty.
 */
export class ComboBox extends AutocompleteField {
    constructor(dataSource, displayProperty = "name", valueProperty = "id", renderer = ComboBoxDefaultRenderer, storeConfig = {
        queryParams: {
            limit: 50
        }
    }) {
        storeConfig.dataSource = dataSource;
        const dropDownTable = table({
            headers: false,
            fitParent: true,
            store: datasourcestore(storeConfig),
            columns: [
                column({
                    id: displayProperty,
                    resizable: true,
                    width: 312,
                    sortable: true,
                    renderer: (columnValue, record, td, table1) => {
                        return Format.escapeHTML(renderer(this, record));
                    }
                })
            ]
        });
        super(dropDownTable);
        this.dataSource = dataSource;
        this.displayProperty = displayProperty;
        this.valueProperty = valueProperty;
        this.renderer = renderer;
        /**
         * When autocompleting from the datasource this filter name will be used.
         */
        this.filterName = "text";
        // load next data on scroll
        this.picker.list.store.addScrollLoader(this.menu.el);
        this.on("autocomplete", async (_field, input) => {
            var _a;
            this.list.store.queryParams.position = 0;
            if (!this.list.store.queryParams.filter) {
                this.list.store.queryParams.filter = {};
            }
            if (this.filter) {
                Object.assign(this.list.store.queryParams.filter, this.filter);
            }
            this.list.store.queryParams.filter[(_a = this.filterName) !== null && _a !== void 0 ? _a : this.displayProperty] = input;
            await this.list.store.load();
        });
    }
    pickerRecordToValue(_field, record) {
        return record[this.valueProperty];
    }
    async valueToTextField(_field, value) {
        if (value === "") {
            return "";
        }
        const record = await this.dataSource.single(value);
        return this.renderer(_field, record);
    }
}
/**
 * Shorthand function to create {@see ComboBox}
 *
 * @link https://goui.io/#form/Select
 * @param config
 */
export const combobox = (config) => {
    var _a, _b, _c, _d;
    return createComponent(new ComboBox(config.dataSource, (_a = config.displayProperty) !== null && _a !== void 0 ? _a : "name", (_b = config.valueProperty) !== null && _b !== void 0 ? _b : "id", (_c = config.renderer) !== null && _c !== void 0 ? _c : ComboBoxDefaultRenderer, (_d = config.storeConfig) !== null && _d !== void 0 ? _d : {
        queryParams: {
            limit: 50
        }
    }), config);
};
//# sourceMappingURL=ComboBox.js.map