/**
* Copyright Intermesh
*
* This file is part of Group-Office. You should have received a copy of the
* Group-Office license along with Group-Office. See the file /LICENSE.TXT
*
* If you have questions write an e-mail to info@intermesh.nl
*
* @copyright Copyright Intermesh
* @author {authorName} <{email}>
*/

go.modules.business.automation.MainPanel = Ext.extend(go.modules.ModulePanel,
{
	id: "automation",
	title: t("Automation"),
	layout: 'responsive',
	layoutConfig: {
		triggerWidth: 1000
	},
	frontendConfig: {},

	initComponent: function () {
		this.frontendConfig = go.modules.business.automation.ModuleConfig.frontendOptions;
		this.createAutomationGrid();



		this.sidePanel = new Ext.Panel({
			layout: 'anchor',
			defaults: {
				anchor: "100%"
			},
			width: dp(300),
			cls: 'go-sidenav',
			region: "west",
			split: true,
			hidden: true,
			autoScroll: true,
			items: [
				this.createFilterPanel()
			]
		});


		if(this.frontendConfig.showDetailPanel) {
			this.AutomationDetail = new go.modules.business.automation.AutomationDetail({
				region: 'center',
				split: true,
				tbar: [{
						cls: 'go-narrow', //will only show on small devices
						iconCls: "ic-arrow-back",
						tooltip: t("Automation"),
						handler: function () {
							this.westPanel.show();
							go.Router.goto("automation");
						},
						scope: this
					}]
			});

			this.westPanel = new Ext.Panel({
				region: "west",
				layout: "responsive",
				stateId: "go-automation-west",
				split: true,
				width: dp(700),
				narrowWidth: dp(400), //this will only work for panels inside another panel with layout=responsive. Not ideal but at the moment the only way I could make it work
				items: [
					this.AutomationGrid, //first is default in narrow mode
					this.sidePanel
				]
			});

			this.items = [
				this.westPanel //first is default in narrow mode
			];

			this.items.push(this.AutomationDetail);
		} else
		{
			this.items = [this.sidePanel, this.AutomationGrid];
		}

		if(this.frontendConfig.showFilter) {
			this.sidePanel.show()
		}

		go.modules.business.automation.MainPanel.superclass.initComponent.call(this);

		//use viewready so load mask can show
		this.AutomationGrid.on("viewready", this.runModule, this);
	},
	runModule: function () {
		this.AutomationGrid.store.load();
	},

	createFilterPanel: function () {
		return new Ext.Panel({
			region: "center",
			minHeight: dp(200),
			autoScroll: true,
			tbar: [{
				xtype: 'tbtitle',
				text: t("Filters")
			},
			'->',
			{
				xtype: 'filteraddbutton',
				entity: 'Automation'
			},{
				cls: 'go-narrow',
				iconCls: "ic-arrow-forward",
				tooltip: t("Automation"),
				handler: function () {
					this.AutomationGrid.show();
					go.Router.goto("automation");
				},
				scope: this
			}],
			items: [
				this.filterGrid = new go.filter.FilterGrid({
					filterStore: this.AutomationGrid.store,
					entity: "Automation"
				}),{
					xtype: 'variablefilterpanel',
					filterStore: this.AutomationGrid.store,
					entity: "Automation"
				}
			]
		});
	},
	createAutomationGrid: function () {
		this.AutomationGrid = new go.modules.business.automation.AutomationGrid({
		region: 'center',
		multiSelectToolbarItems: [
		{
			hidden: go.customfields.CustomFields.getFieldSets('Automation').length == 0,
			iconCls: 'ic-edit',
			tooltip: t("Batch edit"),
			handler: function() {
				var dlg = new go.form.BatchEditDialog({
					entityStore: "Automation"
				});
				dlg.setIds(this.AutomationGrid.getSelectionModel().getSelections().column('id')).show();
			},
			scope: this
		}
		],
		tbar: [{
			cls: 'go-narrow', //Shows on mobile only
			iconCls: "ic-menu",
			handler: function () {
			this.sidePanel.show();
		},
		scope: this
	    },
	    '->',
	    {
		    xtype: 'tbsearch',
		    hidden: !this.frontendConfig.showSearchBar
		},
		this.addButton = new Ext.Button({
			iconCls: 'ic-add',
			tooltip: t('Add'),

			cls: "primary",
			handler: function (btn) {
				var AutomationForm = new go.modules.business.automation.AutomationDialog();
				AutomationForm.show();
			},
			scope: this
	    }),
	    this.moreBtn = new Ext.Button({
			iconCls: 'ic-more-vert',
	            menu: [{
	                itemId: "delete",
	                iconCls: 'ic-delete',
	                text: t("Delete"),

	                handler: function () {
	                    this.AutomationGrid.deleteSelected();
					},
					scope: this
				}]
			})],
			listeners: {
				rowdblclick: this.onGridDblClick,
				scope: this,
				keypress: this.onGridKeyPress
			}
		});

		this.AutomationGrid.on('navigate', function (grid, rowIndex, record) {
			go.Router.goto("Automation/" + record.id);
		}, this);
		if(this.frontendConfig.enableCSV && go.Modules.isAvailable("business","automation", go.permissionLevels.manage)) {
			this.moreBtn.menu.add('-',{
				iconCls: 'ic-cloud-upload',
				text: t("Import"),
				handler: function() {
					go.util.importFile(
						'Automation',
						'.csv, .xlsx, .json ',
						{},
						{}
					);
				},
				scope: this
			},{
				iconCls: 'ic-cloud-download',
				text: t("Export"),
				menu: [{
						text: 'Microsoft Excel',
						iconCls: 'filetype filetype-xls',
						handler: function() {
							go.util.exportToFile(
								'Automation',
								Object.assign(go.util.clone(this.AutomationGrid.store.baseParams), this.AutomationGrid.store.lastOptions.params, {limit: 0, position: 0}),
								'xlsx');
						},
						scope: this
					},{
						text: 'Comma Separated Values',
						iconCls: 'filetype filetype-csv',
						handler: function () {
							go.util.exportToFile(
								'Automation',
								Object.assign(go.util.clone(this.AutomationGrid.store.baseParams), this.AutomationGrid.store.lastOptions.params, {limit: 0, position: 0}),
								'csv');
						},
						scope: this
					},{
						iconCls: 'filetype filetype-json',
						text: 'JSON',
						handler: function() {
							go.util.exportToFile(
								'Automation',
								Object.assign(go.util.clone(this.AutomationGrid.store.baseParams), this.AutomationGrid.store.lastOptions.params, {limit: 0, position: 0}),
								'json');
						},
						scope: this
					}],
					scope: this
				});
		}

			return this.AutomationGrid;
		},
		onGridDblClick: function (grid, rowIndex, e) {
			var record = grid.getStore().getAt(rowIndex);
			if (record.get('permissionLevel') < go.permissionLevels.write) {
				return;
			}

		    var dlg = new go.modules.business.automation.AutomationDialog();
		    dlg.load(record.id).show();
		},

		onGridKeyPress: function (e) {
		if (e.keyCode != e.ENTER) {
			return;
		}
		var record = this.AutomationGrid.getSelectionModel().getSelected();
		if (!record) {
			return;
		}

		if (record.get('permissionLevel') < go.permissionLevels.write) {
			return;
		}

		var dlg = new go.modules.business.automation.AutomationDialog();
		dlg.load(record.id).show();
	}
});
