Ext.define('go.modules.business.business.AgreementDialog',{
	extend: go.form.Dialog,
	width: dp(700),
	height: dp(600),
	formPanelLayout:'border',
	title: t('Agreement'),
	entityStore: "EmployeeAgreement",
	employeeId: null,
	startDate: null,
	finishDate: null,
	initFormItems: function () {
		
		return [{
			region:'center',
			layout:'form',
			xtype:'container',
			items: [{xtype:'fieldset',labelWidth: 60,items:[{
				xtype:'datefield',
				name:'start',
				fieldLabel: t('Start at'),
				value: new Date(),
				disabled: !go.Modules.get("business","business").userRights.mayManageEmployees
			},{
					xtype:'datefield',
					name:'finish',
					fieldLabel: t('Finish at'),
					// value: new Date(),

					disabled: !go.Modules.get("business","business").userRights.mayManageEmployees
			}]},new Ext.form.FieldSet({
				title: t("Year credits", 'business', 'business'),
				labelWidth: 60,
				items: [this.yearBudgetFields = new go.form.FormContainer({name:'budgets',hideLabel:true,labelWidth: 60})]
			})]
		},{
			region:'east',
			layout:'form',
			width: 200,
			xtype:'fieldset',
			labelWidth: 60,
			title: t('Work week', 'business', 'business'),
			defaults: {
				width: dp(160),
				xtype:'timefield',
				format: "G:i",
				increment: 30,
				disabled: !go.Modules.get("business","business").userRights.mayManageEmployees,
				getValue: function() {
					let v = this.getRawValue();
					if(!v) {
						return 0;
					}
					return go.util.Format.minutes(v);
				},
				setValue: function(value) {
					if(!isNaN(value)) {
						value = go.util.Format.duration(value * 60);
					}
					return Ext.form.TimeField.superclass.setValue.call(this, this.formatDate(this.parseDate(value)));
				}
			},
			items: [{
				fieldLabel: t("full_days")[1],
				name:'mo'
			},{
				fieldLabel: t("full_days")[2],
				name:'tu'
			},{
				fieldLabel: t("full_days")[3],
				name:'we'
			},{
				fieldLabel: t("full_days")[4],
				name:'th'
			},{
				fieldLabel: t("full_days")[5],
				name:'fr'
			},{
				fieldLabel: t("full_days")[6],
				name:'sa'
			},{
				fieldLabel: t("full_days")[0],
				name:'su'
			}]
		}, {
			xtype: 'hidden',
			name: 'employeeId'
		}];
	},

	onLoad: function(entityValues) {

		this.fireEvent("load", this, entityValues);
		go.Db.store('Activity').all(function(success,activities) {
			if(success) {
				this.updateYearBudgetComponent(activities, entityValues.budgets || {});
			}
		},this);
	},

	show: function() {
		this.onLoad({budgets:[]});
		this.callParent();
	},

	updateYearBudgetComponent: function(activities, budgets){
		this.yearBudgetFields.removeAll();

		if(!activities.length) {
			this.yearBudgetFields.add({html: t('There are no budgetable activities')});
		} else {
			for (let i = 0, l = activities.length; i < l; i++) {
				let currActivity = activities[i];
				// Transferable budgets are normally special leave and should be defined as such.
				if (!currActivity.budgetable || currActivity.disabled /*|| currActivity.budgetTransferable*/ || currActivity.type === 4) {
					continue;
				}
				let budget = budgets[currActivity.id] || 0;
				this.yearBudgetFields.add(new go.form.FormContainer({

					name: currActivity.id,
					items: [
						new Ext.form.NumberField({
							fieldLabel: currActivity.name,
							serverFormats: true,
							name: 'budget',
							width: dp(140),
							value: budget ? budget.budget : 0, // todo
							decimals: 2,
							maxValue: 8784,
							suffix: t('hours'),
							listeners: {
								'change': function(elm,newValue,oldValue) {
									const record = this.entityStore.data[this.currentId];
									if(go.util.empty(record)) {
										return true;
									}
									// Get cumulative hours for current activity and start and end date.
									GO.request({
										url: 'leavedays/leaveday/budgetedHours',
										params: {
											employeeId: record.employeeId,
											start: record.start,
											finish: record.finish || null,
											activityId: currActivity.id
										},
										success: (options, response, result) => {
											if (result.totalHours > newValue) {
												Ext.MessageBox.confirm(
													t('Warning'),
													t('The number of hours entered is lower than the total requested hours for this leave type for this agreement. Do you wish to continue?', 'leavedays', 'legacy'),
													function( btn) {
														if (btn !== "yes") {
															elm.setValue(oldValue);
														}
													}
												)
											}
										}
									});
								},
								scope: this
							}
						}), new Ext.form.Hidden({
							name: 'activityId',
							value: currActivity.id
						})]
				}));

			}
		}

		this.doLayout();
	}

});
