go.modules.business.catalog.MonthlySalesDetail = Ext.extend(Ext.Panel, {

	title: t("Monthly sales"),
	layout: "fit",
	height: dp(500),
	collapsible: true,
	stateId: "business-catalog-monthly-sales",
	initComponent: function() {

		this.tbar = [
			this.previousYearBtn = new Ext.Button({
				iconCls: 'ic-chevron-left',
				handler: function() {
					this.yearField.setValue(parseInt(this.yearField.getValue()) - 1);
				},
				scope: this
			}),
			this.yearField = new Ext.form.TextField({
				readonly: true,
				width: dp(80),
				style: "text-align: center",
				listeners: {
					setvalue: this.onChange,
					scope: this
				}
			}),
			this.nextYearBtn = new Ext.Button({
				iconCls: 'ic-chevron-right',
				handler: function() {
					this.yearField.setValue(parseInt(this.yearField.getValue()) + 1);
				},
				scope: this
			})

		];

		this.items = [
			this.chart = new go.chart.BarChart({
				width: "auto",
				options: {
					maintainAspectRatio: false, // for height to work
					scales: {
						y: {
							beginAtZero: true
						}
					}
				}
			})
		];

		this.bbar = [
			this.totalField = new Ext.form.Label()
		];

		go.modules.business.catalog.MonthlySalesDetail.superclass.initComponent.call(this);
	},

	onLoad: async function(pnl) {
		console.log(pnl.data);

		this.articleId = pnl.data.id;
		const year = (new Date()).getFullYear();
		this.yearField.setValue(year);
	//	this.onChange(this.yearField, year);
	},

	onChange: function(field, year) {
		Promise.all([
			go.Jmap.request({
				method: "Article/monthlyTotals",
				params: {
					id: this.articleId,
					year: year -1
				}
			})
			,
			go.Jmap.request({
				method: "Article/monthlyTotals",
				params: {
					id: this.articleId,
					year: year
				}
			})
		]).then((totals) => {

			const series = [0,0,0,0,0,0,0,0,0,0,0,0], lastYearSeries = [0,0,0,0,0,0,0,0,0,0,0,0], m = Object.values(t('short_months')), labels = [
				m[0],
				m[1],
				m[2],
				m[3],
				m[4],
				m[5],
				m[6],
				m[7],
				m[8],
				m[9],
				m[10],
				m[11]
			];

			let total = 0, count = 0;

			totals[0].forEach((rec) => {
				lastYearSeries[rec.month - 1] = rec.quantity;
			});

			totals[1].forEach((rec) => {
				series[rec.month - 1] = rec.quantity;

				total += rec.quantity;

				labels[rec.month - 1] += "\n" + rec.quantity;
			});

			this.chart.update([{label: year -1, data:lastYearSeries}, {label: year, data:series}], labels);

			this.totalField.setText(t("Total") + ": " + total , false);

		});
	}
});
