/**
 * Copyright Intermesh
 *
 * This file is part of Group-Office. You should have received a copy of the
 * Group-Office license along with Group-Office. See the file /LICENSE.TXT
 *
 * If you have questions write an e-mail to info@intermesh.nl
 *
 * @copyright Copyright Intermesh
 * @author {authorName} <{email}>
 */
//TODO MAKE WINDOW
go.modules.business.finance.DebtorMainPanel = Ext.extend(go.modules.ModulePanel, {
	layout: 'responsive',


	initComponent: function () {
		this.createDebtorGrid();

		this.sidePanel = new Ext.Panel({

			width: dp(300),
			cls: 'go-sidenav',
			region: "west",
			split: true,
			autoScroll: true,
			layout: "anchor",
			defaults: {
				anchor: "100%"
			},
			tbar: [
				{
					scope: this,
					handler: function() {
						this.ownerCt.getLayout().setActiveItem(0);
					},
					text: t("Close debtors"),
					iconCls: "ic-close"
				}
			],
			items: [
				this.createBusinessPanel(),
				this.createFilterPanel()
			]
		});


		this.items = [
			this.sidePanel,
			this.grid, //first is default in narrow mode

		];

		go.modules.business.finance.PaymentMainPanel.superclass.initComponent.call(this);

		this.on("show", () => {
				this.runModule();
		});
	},


	createFilterPanel: function () {
		return new Ext.form.FieldSet({
			labelAlign: "top",
				region: "center",
				minHeight: dp(200),
				autoScroll: true,
				title: t("Filters"),

				items: [
					{
						hideLabel: true,
						xtype: "checkbox",
						boxLabel: t("Actionable"),
						listeners: {
							scope: this,
							check: function(f, val) {
								this.grid.store.setFilter("actionable", val ? {actionable: true} : null);
								this.grid.store.load();
							}
						}
					},
					//
					this.dateField = new go.form.DateRangeField({
						anchor: "100%",
						fieldLabel: t("Date"),
						listeners: {
							scope: this,
							change: function(f, val) {
								this.grid.store.setFilter("date", val ? {date: val} : null);
								if(this.started) {
									this.grid.store.load();
								}
							}
						}
					})
				]

			}
		);
	},

	runModule: function () {

		var me = this;
		this.documentBusinessGrid.store.load().then(function() {
			me.dateField.setThisYear();
			me.documentBusinessGrid.getSelectionModel().on('selectionchange', me.onFinanceBusinessSelectionChange, me, {buffer: 1}); //add buffer because it clears selection first
			me.documentBusinessGrid.getSelectionModel().selectRow(0);
			setTimeout(() => {
				//select row has a delay
				me.started = true;
			}, 100)

			me.grid.store.load();
		});
	},

	createBusinessPanel : function() {
		this.documentBusinessGrid = new go.modules.business.finance.FinanceBusinessGrid({
			region: "north",
			autoHeight: true,
			title: t("Business")
		});

		return this.documentBusinessGrid;
	},

	onFinanceBusinessSelectionChange : function (sm) {
		var selected = sm.getSelected();
		if(!selected) {
			Ext.MessageBox.alert(t("No business", "There are no businesses defined yet in the system settings"));
			this.setDisabled(true);
		}

		this.businessId = selected.data.id;

		go.modules.business.finance.business = selected.data;

		this.grid.store.setFilter("business", {businessId: this.businessId});
		if(this.started) {
			this.grid.store.load();
		}

	},



	createDebtorGrid: function () {
		this.grid = new go.modules.business.finance.DebtorGrid({
			region: 'center',

			listeners: {
				rowdblclick: (grid, rowIndex, e) => {
					const win = new go.links.LinkDetailWindow({
						entity: "Contact"
					});

					const record = grid.store.getAt(rowIndex);
					win.load(record.data.contactId);
				},
				scope: this
			},
			tbar: [{
				cls: 'go-narrow', //Shows on mobile only
				iconCls: "ic-menu",
				handler: function () {
					this.sidePanel.show();
				},
				scope: this
			},
				'->',
				{
					xtype: 'tbsearch'
				},
				{
					xtype: "button",
					iconCls: "ic-notification-important",
					text: t("Process actions"),
					menu: {
						cls: "x-menu-no-icons",
						items:[
							{
								text: t("Test reminders"),
								scope: this,
								handler: function() {
									if(confirm(t("This will send out reminders to the billing email address for testing. Do you want to continue?"))) {
										this.runActions(true)
									}
								}
							}
						,
							{
								text: t("Send reminders"),
								scope: this,
								handler: function() {

									if(confirm(t("Are you sure you want to send out reminders?"))) {
										this.runActions(false)
									}

								}
							}
						]
					}
				}
				]
		});


		return this.grid;
	},

	runActions : async function(dryRun) {
		const oldRT = go.Jmap.requestTimeout;
		go.Jmap.requestTimeout = 180000;

		try {
			this.getEl().mask(t("Loading..."));

			const q = await go.Db.store("Payment").query({
				filter: {businessId: this.businessId, checked: false},
				limit: 1
			});

			if(q.ids.length) {
				if(!confirm(t("There are unverified payments. Are you sure you want to proceed with sending reminders?"))){
					return;
				}
			}



			const response = await go.Jmap.request({
				method: "Debtor/runActions",
				params: {
					businessId: this.businessId,
					dryRun: dryRun
				}
			});

			let msg = t("Processed {count} actions").replace("{count}", response.count);

			if (response.errors.length) {
				msg += "<hr />" + t("There were {count} errors:").replace("{count}", response.errors.length) + "<br />";
				msg += response.errors.map((e) => Ext.util.Format.htmlEncode(e)).join("<br />");
			}

			Ext.MessageBox.alert(t("Process actions"), msg);

			this.grid.store.load();

			const count = await go.Jmap.request({method: "Debtor/countActions"});
			GO.mainLayout.setNotification('finance', count,'orange');

		} catch(e) {
			GO.errorDialog.show(e);
		} finally {
			this.getEl().unmask();

			go.Jmap.requestTimeout = oldRT;
		}
	}

});