/**
 * Copyright Intermesh
 *
 * This file is part of Group-Office. You should have received a copy of the
 * Group-Office license along with Group-Office. See the file /LICENSE.TXT
 *
 * If you have questions write an e-mail to info@intermesh.nl
 *
 * @copyright Copyright Intermesh
 * @author {authorName} <{email}>
 */

go.modules.business.finance.MainPanel = Ext.extend(go.modules.ModulePanel, {
	id: "finance",
	title: t("Finance"),

	layout: {
		type: "card",
		deferredRender: true
	},
	activeItem:0,

	setDebtorActions  : function(count) {
		let txt = t("Debtors", "finance", "business");

		if(count)
			txt += `<span class="badge right">${count}</span>`;

		this.items.itemAt(0).debtorBtn.setText(txt)
	},

	initComponent: function () {

		this.items = [
			new go.modules.business.finance.FinanceDocumentMainPanel(),
			new go.modules.business.finance.PaymentMainPanel(),
			new go.modules.business.finance.DebtorMainPanel()
		]

		go.modules.business.finance.MainPanel.superclass.initComponent.call(this);

	}
});