/* global go */

go.modules.business.newsletters.Composer = Ext.extend(go.form.Dialog, {
	title: t('Compose'),
	entityStore: "Newsletter",
	width: dp(1000),
	height: dp(800),
	formPanelLayout: "fit",
	resizable: true,
	maximizable: true,
	collapsible: true,
	modal: false,
	initButtons : function() {},
	initComponent: function() {
		this.tbar = [{
			tooltip: t("Send"),
			iconCls: 'ic-send',
			scope: this,
			text: t("Send"),
			handler: function() {
				this.submit();
			}
		},'->',
			{
				text:t('Upload message'),
				iconCls: 'ic-file-upload',
				handler: () => {
					go.util.openFileDialog({
						autoUpload: true,
						accept: 'application/zip',
						listeners: {
							upload: function(response) {
								go.Jmap.request({
									method: "EmailTemplate/fromZip",
									params: {
										blobId: response.blobId,
										subject: '',
										package: "business",
										module: "newsletters"
									},
									callback: function (options, success, response) {
										Ext.getBody().unmask();
										if (!success) {
											Ext.MessageBox.alert(t("Error"), response.message);
										} else {
											const cleanBody = DOMPurify.sanitize(response.body);
											this.displayTemplate(cleanBody);
											this.setValues({
												subject: response.subject,
												attachments: response.attachments,
												body: cleanBody
											});

										}
									},
									scope:this
								});
							},
							scope: this
						}
					})
				}
			},
			{
				tooltip: t("Send a test message to the selected outgoing account e-mail. The first recipient will be used for the template."),
				iconCls: 'ic-pageview',
				text: t("Test message"),
				scope: this,
				handler: function() {
					this.getEl().mask(t("Sending..."));
					var me = this;
					go.Jmap.request({
						method: 'Newsletter/test',
						params: this.getValues()
					}).then(function() {
						Ext.MessageBox.alert(t("Sent"), t("A test message was sent"));
					}).catch(function(result) {

						GO.errorDialog.show(result.message);

					}).finally(function() {
						me.getEl().unmask();
					})
				}
			},
			{
				listeners: {
					scope: this,
					render: function(menu) {

						this.templatesMenu.store.load({
							scope: this,
							callback: function() {

								if(this.currentId) {
									return;
								}

								var first = this.templatesMenu.store.getAt(0);
								if(first) {
									this.setValues({
										subject: first.data.subject,
										attachments: first.data.attachments,
										body: first.data.body
									});
								}
							}
						});
					}
				},
				tooltip: t("Select a template"),
				text: t("Template"),
				iconCls: 'ic-style',
				menu: this.templatesMenu = new go.menu.StoreMenu({
					// cls: "x-menu-no-icons",
					displayField: "name",
					store: new go.data.Store({
						fields: ['name', 'body', 'subject', 'attachments'],
						entityStore: "EmailTemplate",
						baseParams: {filter: {
							module: {name: 'newsletters', package: 'business'}
						}}
					}),
					listeners: {
						scope: this,
						createitem: function(item, record, index) {
							item.group = "template";
							item.checked = index === 0;

							item.listeners = {
								checkchange: function(item, checked) {
									this.setValues({
										subject: item.record.data.subject,
										attachments: item.record.data.attachments,
										body: item.record.data.body
									});
								},

								scope: this
							};
						}
					}
				})
			}];


		go.modules.business.newsletters.Composer.superclass.initComponent.call(this);
	},

	displayTemplate(html) {
		this.contentCard.removeAll();
		this.contentCard.setAutoScroll(true);
		this.contentCard.add([{
			xtype:'hidden',
			name: 'body',
		},
		this.htmlPreview = new Ext.BoxComponent({ // readonly HTMLinsert
			listeners: {
				'render': me => {
					me.getEl().dom.style.overflow = 'auto';
					me.shadowDom = me.getEl().dom.attachShadow({ mode: "closed" });
					me.shadowDom.innerHTML = html;
				}
			}
		})]);
	},

	initFormItems: function () {

		const me = this;
		const smtpAccount = new go.smtp.AccountCombo({
			allowBlank: false,
			anchor: '100%',
			pageSize: undefined,
			listeners: {
				scope: this,
				render: function(combo) {
					combo.doQuery(combo.allQuery, true);
				}
			}
		});
		const items = [{
			xtype: 'fieldset',
			layout: "border",
			items: [{
				region: "center",
				xtype: "panel",
				layout: "form",
				// defaults: {
				// 	anchor: '100%'
				// },
				items: [smtpAccount,
					{
						xtype: 'textfield',
						name: 'subject',
						anchor: '100%',
						fieldLabel: t("Subject")
					},this.contentCard = new Ext.Container({
						layout:'fit',
						anchor: "100% -" + dp(168),
						items: [
							{
								xtype:'xhtmleditor',
								plugins: [new GO.plugins.HtmlEditorImageInsert()],
								name: 'body',
								hideLabel: true,
								listeners: {
									attach: this.onAttach,
									scope: this
								}
							}
						]
					}),
					this.attachments = new go.form.AttachmentsField({
						region: "south",
						name: "attachments"
					})
				]
			}
			]
		}
		];

		smtpAccount.store.on('load', (store) => {
			// fetch the rest from email account and append
			GO.request({
				url: 'email/account/store',
				params: {
					sort: "user"
				},
				success: (options, response, result) =>
				{
					for(const item of result.results) {
						store.add(new store.recordType({
							id:'old_'+item.id,
							host: item.smtp_host,
							name: item.name + ' - ' + item.email,
							fromName: item.name,
							fromEmail: item.email
						}, 'old_'+item.id));
					}

					if(smtpAccount.innerList) {
						smtpAccount.restrictHeight();
						smtpAccount.expand();
					}

					if(!store.getCount()) {
						Ext.MessageBox.alert(t("No account"), t("Please setup an outgoing e-mail account first"), function () {
							me.close();
							go.Router.goto("systemsettings/newsletters");
						});
					} else {
						if(!smtpAccount.getValue()) {
							smtpAccount.selectFirst();
						} else {
							smtpAccount.setValue(smtpAccount.getValue());
						}
					}

				}
			});
		})

		return items;
	},

	onAttach: function (htmleditor, blob, file, imgEl) {

		//Inline images are parsed form the body and should not be sent as attachment
		if (imgEl) {
			return;
		}

		this.attachments.addAttachment({
			blobId: blob.blobId,
			name: file.name,
			attachment: true
		});
	}
});


