/**
* Copyright Intermesh
*
* This file is part of Group-Office. You should have received a copy of the
* Group-Office license along with Group-Office. See the file /LICENSE.TXT
*
* If you have questions write an e-mail to info@intermesh.nl
*
* @copyright Copyright Intermesh
* @author {authorName} <{email}>
*/

{namespace}.MainPanel = Ext.extend(go.modules.ModulePanel, {
    id: "{moduleName}",
    title: t("{moduleTitle}"),

    layout: 'responsive',
    layoutConfig: {
        triggerWidth: 1000
    },

    add{ownerEntityName}Id: undefined,

    initComponent: function () {
        this.frontendConfig = {namespace}.ModuleConfig.frontendOptions;

        this.create{itemEntityName}Grid();

        this.sidePanel = new Ext.Panel({
            autoScroll: true,
            layout: "anchor",
            defaultAnchor: '100%',
            width: dp(300),
            cls: 'go-sidenav',
            region: "west",
            split: true,
            items: [
                this.create{ownerEntityName}Grid(),
                {xtype:'filterpanel', store: this.{itemEntityName}Grid.store, entity: '{itemEntityName}'}
            ]
        });


        if(this.frontendConfig.showDetailPanel) {
            this.{itemEntityName}Detail = new {namespace}.{itemEntityName}Detail({
            region: 'center',
            split: true,
            tbar: [{
                cls: 'go-narrow', //will only show on small devices
                iconCls: "ic-arrow-back",
                handler: () => {
                    go.Router.goto("{moduleName}");
                },
                scope: this
                }]
            });

            // route to main grid when details resets / is deleted for mobile view
            this.{entityName}Detail.on("reset", () => {
                go.Router.goto("{moduleName}");
            });

            this.westPanel = new Ext.Panel({
                region: "west",
                layout: "responsive",
                stateId: "go-{moduleName}-west",
                split: true,
                width: dp(700),
                narrowWidth: dp(400), //this will only work for panels inside another panel with layout=responsive. Not ideal but at the moment the only way I could make it work
                items: [
                    this.{itemEntityName}Grid, //first is default in narrow mode
                    this.sidePanel
                ]
            });

            this.items = [
                this.westPanel, //first is default in narrow mode
            ];

            this.items.push(this.{entityName}Detail);
        } else {
            this.items = [this.sidePanel, this.{entityName}Grid];
        }

        if (this.frontendConfig.showFilder) {
            this.sidePanel.show();
        }

        {namespace}.MainPanel.superclass.initComponent.call(this);

        //use viewready so load mask can show
        this.{ownerEntityName}Grid.on("viewready", this.runModule, this);
    },

    runModule : function() {
        this.setDefaultSelection();
        this.{ownerEntityName}Grid.getStore().load();
        this.{itemEntityName}Grid.getStore().load();
    },

    create{ownerEntityName}Grid : function() {
        this.{ownerEntityName}Grid = new {namespace}.{ownerEntityName}Grid({
            region: "north",
            filterName: "{ownerEntityName}Id",
            filteredStore: this.{itemEntityName}Grid.store,
            showMoreLoader: true,
            tbar: [{
                xtype: 'tbtitle',
                text: this.frontendConfig.collectionFilterHeader
            }, '->', {
                xtype: "tbsearch"
            },{
                iconCls: 'ic-add',
                tooltip: t('Add'),
                handler: function (e, toolEl) {
                    const dlg = new {namespace}.{ownerEntityName}Dialog();
                    dlg.show();
                }
            },{
                cls: 'go-narrow',
                iconCls: "ic-arrow-forward",
                handler: function () {
                    this.{itemEntityName}Grid.show();
                },
                scope: this
            }],
            listeners: {
                afterrender: function(grid) {
                    new Ext.dd.DropTarget(grid.getView().mainBody, {
                    ddGroup : "{ownerEntityName}DD",
                    notifyDrop :  (source, e, data) => {
                        const selections = source.dragData.selections,
                            dropRowIndex = grid.getView().findRowIndex(e.target),
                            entityId = grid.getView().grid.store.data.items[dropRowIndex].id;

                        const update = {};
                        selections.forEach((r) => {
                            update[r.id] = {{lcOwnerEntityName}Id: entityId};
                        });

                        go.Db.store("{itemEntityName}").set({update: update});
                    }
                    });
                },
                rowclick: function(grid, row, e) {
                    if(e.target.className != 'x-grid3-row-checker') {
                        //if row was clicked and not the checkbox then switch to grid in narrow mode
                        this.setDefaultSelection();
                        this.{itemEntityName}Grid.show();
                    }
                },
                scope: this
            }
        });

        this.{ownerEntityName}Grid.on('selectionchange', this.setDefaultSelection, this);

        return this.{ownerEntityName}Grid;
    },


    create{itemEntityName}Grid : function() {
        this.{itemEntityName}Grid = new {namespace}.{itemEntityName}Grid({
            region: 'center',
            ddGroup: "{ownerEntityName}DD",
            enableDrag: true,
            multiSelectToolbarItems: [{
                hidden: go.customfields.CustomFields.getFieldSets('{itemEntityName}').length == 0,
                iconCls: 'ic-edit',
                tooltip: t("Batch edit"),
                handler: function() {
                const dlg = new go.form.BatchEditDialog({
                    entityStore: "{itemEntityName}"
                });
                dlg.setIds(this.{itemEntityName}Grid.getSelectionModel().getSelections().column('id')).show();
            },
            scope: this
        }],
        tbar: [{
            cls: 'go-narrow', //Shows on mobile only
            iconCls: "ic-menu",
            handler: function () {
                this.sidePanel.show();
            },
            scope: this
            },
            '->',
            {
            xtype: 'tbsearch',
            filters: [
                'text',
                {name: 'modified', multiple: false},
                {name: 'created', multiple: false}
            ]},
            this.addButton = new Ext.Button({
                iconCls: 'ic-add',
                tooltip: t('Add'),
                cls: "primary",
                handler: function (btn) {
                    const {itemEntityName}Form = new {namespace}.{itemEntityName}Dialog();
                    {itemEntityName}Form.show();
                    {itemEntityName}Form.setValues({
                        {lcOwnerEntityName}Id: this.add{ownerEntityName}Id
                    });
                },
                scope: this
            }),

            this.moreBtn = new Ext.Button({
                iconCls: 'ic-more-vert',
                menu: [{
                    itemId: "delete",
                    iconCls: 'ic-delete',
                    text: t("Delete"),
                    handler: function () {
                        this.{itemEntityName}Grid.deleteSelected();
                    },
                    scope: this
                }]
            })],
            listeners: {
                rowdblclick: this.onGridDblClick,
                keypress: this.onGridKeyPress,
                scope: this
                }
            });

        this.{itemEntityName}Grid.on('navigate', function (grid, rowIndex, record) {
            go.Router.goto("{itemEntityName}/" + record.id);
        }, this);
        if(this.frontendConfig.enableCSV && go.Modules.get("{packageName}","{moduleName}").userRights.mayManage) {
            this.moreBtn.menu.add('-',{
                iconCls: 'ic-cloud-upload',
                text: t("Import"),
                handler: function() {
                    go.util.importFile(
                        '{itemEntityName}',
                        '.csv, .xlsx, .json ',
                        {},
                        {}
                    );
                },
                scope: this
            },{
                iconCls: 'ic-cloud-download',
                text: t("Export"),
                menu: [{
                    text: 'Microsoft Excel',
                    iconCls: 'filetype filetype-xls',
                    handler: function() {
                        go.util.exportToFile(
                            '{itemEntityName}',
                            Object.assign(go.util.clone(this.{itemEntityName}Grid.store.baseParams), this.{itemEntityName}Grid.store.lastOptions.params, {limit: 0, position: 0}),
                            'xlsx');
                    },
                    scope: this
                },{
                    text: 'Comma Separated Values',
                    iconCls: 'filetype filetype-csv',
                    handler: function () {
                    go.util.exportToFile(
                        '{itemEntityName}',
                        Object.assign(go.util.clone(this.{itemEntityName}Grid.store.baseParams), this.{itemEntityName}Grid.store.lastOptions.params, {limit: 0, position: 0}),
                    'csv');
                    },
                    scope: this
                },{
                    iconCls: 'filetype filetype-json',
                    text: 'JSON',
                    handler: function() {
                        go.util.exportToFile(
                            '{itemEntityName}',
                            Object.assign(go.util.clone(this.{itemEntityName}Grid.store.baseParams), this.{itemEntityName}Grid.store.lastOptions.params, {limit: 0, position: 0}),
                            'json'
                        );
                    },
                    scope: this
                }],
            scope: this
        });
        }

        return this.{itemEntityName}Grid;
    },

    setDefaultSelection: function() {
        this.add{ownerEntityName}Id = false;
        this.addButton.setDisabled(true);
        if(this.{ownerEntityName}Grid.getSelectedIds().length) {
            go.Db.store("{ownerEntityName}").get(this.{ownerEntityName}Grid.getSelectedIds()).then((result) => {
               result.entities.forEach((item) => {
                    if (!this.add{ownerEntityName}Id && item.permissionLevel >= go.permissionLevels.create) {
                        this.add{ownerEntityName}Id = item.id;
                        this.addButton.setDisabled(false);
                    }
                });
            });
        } else {
            go.Db.store("{ownerEntityName}").all((result, data) => {
                for (const item of data) {
                    this.add{ownerEntityName}Id = item.id;
                    this.addButton.setDisabled(false);
                    break;
                }
            })
        }
    },

    onGridDblClick : function (grid, rowIndex, e) {

        const record = grid.getStore().getAt(rowIndex);
        if (record.get('permissionLevel') < go.permissionLevels.write) {
            return;
        }

        const dlg = new {namespace}.{itemEntityName}Dialog();
        dlg.load(record.id).show();
    },

    onGridKeyPress : function(e) {
        if(e.keyCode != e.ENTER) {
            return;
        }
        const record = this.{itemEntityName}Grid.getSelectionModel().getSelected();
        if(!record) {
            return;
        }

        if (record.get('permissionLevel') < go.permissionLevels.write) {
            return;
        }

        const dlg = new {namespace}.{itemEntityName}Dialog();
            dlg.load(record.id).show();
        }
    });

