<?php
namespace {namespace}\model;

use go\core\db\Criteria;
use go\core\jmap\Entity;
use go\core\model\Acl;
use go\core\orm\CustomFieldsTrait;
use go\core\orm\SearchableTrait;
use go\core\data\convert\Spreadsheet;
use go\core\orm\Mapping;
use go\core\orm\Filters;
use go\core\util\DateTime;
use go\modules\business\studio\model\Studio;
use {namespace}\Module;

/**
 * $entity model
 *
 *
 * @copyright (c) {year}, Intermesh BV https://www.intermesh.nl
 * @author {authorName} <{email}>
 * @license http://www.gnu.org/licenses/agpl-3.0.html AGPLv3
 */
class {model} extends Entity
{
	use SearchableTrait;
	use CustomFieldsTrait;

	/** @var int  */
	public $id;

	/** @var int  */
	public $createdBy;

	/** @var DateTime  */
	public $createdAt;

	/** @var int  */
	public $modifiedBy;

	/** @var DateTime  */
	public $modifiedAt;

	/** @var int */
	public $filesFolderId;

	protected static function defineMapping(): Mapping
	{
		return parent::defineMapping()
			->addTable("{tablePrefix}_{tableAlias}", "{tableAlias}");
	}

	protected function getSearchDescription(): string
	{
		{searchDescriptionFld}
	}

	public function title(): string
	{
		return {searchNameFld} ?? parent::title();
	}

	protected function internalGetPermissionLevel(): int
	{
		return Module::get()->getModel()->getPermissionLevel();
	}

	protected function canCreate(): bool
	{
		return Module::get()->getModel()->hasPermissionLevel(Acl::LEVEL_MANAGE);
	}

	public function findAclId(): ?int
	{
		$module = Module::get()->getModel();

		return Studio::find()
			->selectSingleValue('moduleAclId')
			->where(['name' => $module->package .'-'.$module->name])
			->single();
	}


	protected static function defineFilters(): Filters
	{
		return parent::defineFilters()
			->add('id', function(Criteria $criteria, $value) {
				if(!empty($value)) {
					$criteria->where(['id' => $value]);
				}
			});
	}

	/**
	 * @inheritDoc
	 */
	public static function converters(): array
    {
		return array_merge(parent::converters(), [Spreadsheet::class]);
	}
}
