<?php


namespace GO\Billing;


use Faker\Generator;
use GO\Billing\Model\Product;
use go\core\model\Acl;
use go\core\model\User;
use go\modules\community\addressbook\Module;

class BillingModule extends \GO\Professional\Module {
	
	private static $_defaultLangId;

	public function author() {
		return 'Merijn Schering';
	}

	public function authorEmail() {
		return 'mschering@intermesh.nl';
	}
	
	public function package() {
		return "Billing";
	}

	public function getStatus(): string
	{
		return \go\core\Module::STATUS_DEPRECATED;
	}

	/**
	 * 
	 * When a user is created, updated or logs in this function will be called.
	 * The function can check if the default calendar, addressbook, notebook etc.
	 * is created for this user.
	 * 
	 */
	public static function firstRun() {
		
	}

	public function install() {

		parent::install();
		
		$lang = new Model\Language();
		$lang->id=1;
		$lang->name=\GO::t("Default", "billing");
		$lang->language=\GO::config()->language;
		$lang->save();
		
		
		$quoteBook = new Model\Book();
		$quoteBook->name=\GO::t("Quotes", "billing");
		$quoteBook->order_id_prefix="Q%y";
		$quoteBook->call_after_days=3;
		$quoteBook->createStatuses=array('Sent' => '00CCFF','Accepted' => '2AD56F','Lost' => 'FF0000','In process' => 'FF9900');
		$quoteBook->save();
		
		$orderBook = new Model\Book();
		$orderBook->name=\GO::t("Orders", "billing");
		$orderBook->order_id_prefix="O%y";
		$quoteBook->createStatuses=array('In process' => 'FF9900','Delivered'=>'yellow','Sent' => '00CCFF','Billed' => '2AD56F');
		$orderBook->save();
		
		$invoiceBook = new Model\Book();
		$invoiceBook->name=\GO::t("Invoices", "billing");
		$invoiceBook->order_id_prefix="I%y";
		$invoiceBook->save();
		
		
		if (\GO::modules()->files) {
	
			$folder = \GO\Files\Model\Folder::model()->findByPath('billing/product_images',true);
			if($folder->acl_id != Product::entityType()->getDefaultAclId()){
				$folder->acl_id=Product::entityType()->getDefaultAclId();
				$folder->save(true);		
			}
		}

		return true;
	}
	
	public function autoInstall() {
		return false;
	}

	
	public static function getDefaultLangId(){
		if(!isset(self::$_defaultLangId)){
			$lang = Model\Language::model()->findSingleByAttribute('language',\GO::language()->getLanguage());
			self::$_defaultLangId = $lang ? $lang->id : 1;
		}
		return self::$_defaultLangId;
	}
	
	
	public function checkDatabase(&$response) {
		parent::checkDatabase($response);
		
		if (\GO::modules()->files) {
	
			$folder = \GO\Files\Model\Folder::model()->findByPath('billing/product_images',true);

			$mod = \go\core\model\Module::findByName(null, "billing");
			if($folder->acl_id != $mod->getShadowAclId()){
				$folder->acl_id=$mod->getShadowAclId();
				$folder->save(true);		
			}
		}
		
	}

	public function demo(Generator $faker)
	{

		$supplier = Module::get()->demoCompany($faker);

		$demo = User::find()->where('username', '=', 'demo')->single();

		$articles = [];
		for($i = 0; $i < 10; $i ++) {
			$articleId = "1" .str_pad($i,5, "0");
			$rocket = \GO\Billing\Model\Product::model()->findSingleByAttribute('article_id', $articleId);
			if (!$rocket) {
				$rocket = new \GO\Billing\Model\Product();
				$rocket->article_id = $articleId;
				$rocket->supplier_company_id = $supplier->id;
				$rocket->unit = 'pcs';

				$rocket->list_price = $rocket->total_price = $faker->randomFloat(2, 1, 3000);
				$rocket->cost_price = $rocket->list_price / 2;
				$rocket->vat = 0;
				if (!$rocket->save())
					var_dump($rocket->getValidationErrors());


				$lang = new \GO\Billing\Model\ProductLanguage();
				$lang->language_id = 1;
				$lang->product_id = $rocket->id;
				$lang->name = $faker->text(20);
				$lang->description = $faker->text(100);
				$lang->save();
			}

			$articles[] = $rocket;
		}

		$articlesCount = count($articles) -1;


		$books = \GO\Billing\Model\Book::model()->find();
		foreach($books as $book){

			$statuses = $book->statuses->fetchAll();

			$statusesCount = count($statuses) -1;

			//give demo access
			$book->acl->addGroup(\go\core\model\Group::find()->where(['isUserGroupFor' => $demo->id])->single()->id, \GO\Base\Model\Acl::WRITE_PERMISSION);

			for($n = 0; $n < 10; $n++) {
				$order = new \GO\Billing\Model\Order();
				$order->book_id = $book->id;
				$order->btime = $faker->dateTimeBetween("-1 years", "now")->format("U");
				$order->setCustomerFromContact(Module::get()->demoContact($faker));
				$order->setCustomerFromCompany(Module::get()->demoCompany($faker));
				$order->save();

				for ($i = 0; $i < $faker->numberBetween(1, 10); $i++) {
					$order->addProduct($articles[$faker->numberBetween(0, $articlesCount)], $faker->numberBetween(1, 10));
				}

				$order->status_id = $statuses[$faker->numberBetween(0, $statusesCount)]->id;
				$order->syncItems();

				echo ".";
			}


		}
	}
}
