GO.timeregistration2.ProjectSelectorDialog = Ext.extend(go.Window, {

    initComponent: function () {

        this.formPanel = new Ext.form.FormPanel({
            waitMsgTarget: true,
            border: false,
            layout: 'fit',
            items: [
                {
                    xtype: 'panel',
                    cls: 'go-form-panel',
                    autoScroll: true,
                    layout: 'form',
                    items: [
                        this.projectField = new GO.projects2.SelectProject({
                            anchor: '100%',
                            allowBlank: true,
                            emptyText: '',
                            store: GO.projects2.selectBookableProjectStore,
                        }),
                    ]
                }
            ]
        });

        Ext.apply(this, {
            width: 500,
            height: 150,
            layout: 'fit',
            stateId: 'timeregistration2-projectSelectorDialog',
            listeners: {
                show: function (win) {
                    win.items.get(0).focus();
                }
            },
            items: [
                this.formPanel,
            ],
            buttons: [
                {
                    text: t('Start Timer'),
                    handler: function () {
                        this.fireEvent('starttimer', this, this.projectField.getValue());
                        this[this.closeAction]();
                    },
                    scope: this
                }
            ]
        });

        this.supr().initComponent.call(this);

        this.addEvents({'starttimer': true})
    },
});