/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { Config } from "../Observable";
import { FieldEventMap } from "./Field";
import { InputField } from "./InputField";
export interface NumberField {
    set value(v: number | undefined);
    get value(): number | undefined;
}
/**
 * NumberField component
 */
export declare class NumberField extends InputField {
    protected baseCls: string;
    /**
     * Multiply value with this number on set and divide on get value
     */
    multiplier: number;
    constructor();
    protected validate(): void;
    protected internalSetValue(v?: number | undefined): void;
    private isEmptyNumber;
    protected internalGetValue(): number | undefined;
    /**
     * The step attribute is a number that specifies the granularity that the value must adhere to or the keyword any.
     *
     * @link https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/step
     * @param step
     */
    set step(step: number | undefined | "any");
    get step(): number | undefined | "any";
    /**
     * Set the number of decimals. It uses the step attribute to accomplish this.
     *
     * @param decimals
     */
    set decimals(decimals: number | undefined);
    get decimals(): number | undefined;
    /**
     * The minimum number allowed
     *
     * @param min
     */
    set min(min: number | undefined);
    get min(): number | undefined;
    /**
     * The maximum number allowed
     *
     * @param max
     */
    set max(max: number | undefined);
    get max(): number | undefined;
}
export declare const numberfield: (config?: Config<NumberField, FieldEventMap<NumberField>>) => NumberField;
//# sourceMappingURL=NumberField.d.ts.map