<?php

$updates['202002270906'][] = 'ALTER TABLE `business_activity` ADD COLUMN `budgetable` TINYINT(4) NULL DEFAULT 0 AFTER `billable`;';
$updates['202002270906'][] = 'ALTER TABLE `business_activity_rate` ADD COLUMN `budget` FLOAT NULL DEFAULT NULL AFTER `externalRate`;';

$updates['202003271015'][] = 'CREATE TABLE `business_business_custom_fields` (
    `id` INT UNSIGNED NOT NULL,
    PRIMARY KEY (`id`),
    CONSTRAINT `business_business_custom_fields_ibfk_1`
        FOREIGN KEY (`id`)
        REFERENCES `business_business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;';


$updates['202004201500'][] = 'ALTER TABLE `business_activity_budget`
DROP FOREIGN KEY `fk_business_activity_budget_business_activity1`,
DROP FOREIGN KEY `fk_business_activity_budget_business_employee_agreement1`;';
$updates['202101101300'][] = 'ALTER TABLE `business_activity_budget`
ADD CONSTRAINT `fk_business_activity_budget_business_activity1`
  FOREIGN KEY (`activityId`)
  REFERENCES `business_activity` (`id`)
  ON DELETE RESTRICT
  ON UPDATE NO ACTION,
ADD CONSTRAINT `fk_business_activity_budget_business_employee_agreement1`
  FOREIGN KEY (`agreementId`)
  REFERENCES `business_agreement` (`id`)
  ON DELETE CASCADE
  ON UPDATE NO ACTION;';

$updates['202101101300'][] = 'ALTER TABLE `business_agreement`
DROP FOREIGN KEY `fk_business_agreement_business_employee1`;';

$updates['202101101300'][] = 'ALTER TABLE `business_agreement`
ADD INDEX `fk_business_agreement_business_employee1_idx` (`employeeId` ASC),
DROP INDEX `fk_business_agreement_business_employee1_idx` ;';

$updates['202101101300'][] = 'ALTER TABLE `business_agreement`
ADD CONSTRAINT `fk_business_agreement_business_employee1`
  FOREIGN KEY (`employeeId`)
  REFERENCES `core_user` (`id`)
  ON DELETE CASCADE
  ON UPDATE NO ACTION;';

$updates['202101101300'][] = 'ALTER TABLE `business_manager` 
DROP FOREIGN KEY `fk_business_employeebusiness_employee_business_employee1`,
DROP FOREIGN KEY `fk_business_employeebusiness_employee_business_employee2`;';
$updates['202101101300'][] = 'ALTER TABLE `business_manager` 
ADD INDEX `fk_business_employeebusiness_employee_business_employee2_idx` (`managerId` ASC),
DROP INDEX `fk_business_employeebusiness_employee_business_employee2_idx` ,
DROP PRIMARY KEY;';

$updates['202101101300'][] = 'ALTER TABLE `business_manager` 
ADD CONSTRAINT `fk_business_employeebusiness_employee_business_employee1`
  FOREIGN KEY (`subjectId`)
  REFERENCES `core_user` (`id`)
  ON DELETE CASCADE
  ON UPDATE NO ACTION,
ADD CONSTRAINT `fk_business_employeebusiness_employee_business_employee2`
  FOREIGN KEY (`managerId`)
  REFERENCES `core_user` (`id`)
  ON DELETE CASCADE
  ON UPDATE NO ACTION;';

$updates['202101101300'][] = <<<SQL
ALTER TABLE `business_activity`
ADD COLUMN `budgetTransferable` TINYINT(1) NOT NULL DEFAULT 0;
SQL;
$updates['202111191634'][] = <<<SQL
ALTER TABLE `business_activity`
ADD COLUMN `sortOrder` INT(11) UNSIGNED NOT NULL DEFAULT 0;
SQL;



$updates['202112131426'][] = 'alter table business_activity_rate
    drop foreign key fk_business_employee_activity_business_activity1;';

$updates['202112131426'][] = 'alter table business_activity_rate
    add constraint fk_business_employee_activity_business_activity1
        foreign key (activityId) references business_activity (id)
            on delete cascade;';

$updates['202112131426'][] = 'alter table business_activity_rate
    drop foreign key fk_business_employee_activity_business_employee1;';

$updates['202112131426'][] = 'alter table business_activity_rate
    add constraint fk_business_employee_activity_business_employee1
        foreign key (employeeId) references business_employee (id)
            on delete cascade;';


$updates['202112131426'][] = 'alter table business_activity_budget
    drop foreign key fk_business_activity_budget_business_activity1;';

$updates['202112131426'][] = 'alter table business_activity_budget
    add constraint fk_business_activity_budget_business_activity1
        foreign key (activityId) references business_activity (id)
            on delete cascade;';

$updates['202112131426'][] = 'alter table business_manager
    drop foreign key fk_business_employeecore_user_core_user1;';

$updates['202112131426'][] = 'alter table business_manager
    add constraint fk_business_employeecore_user_core_user1
        foreign key (subjectId) references core_user (id)
            on delete cascade;';

$updates['202112131426'][] = 'alter table business_manager
    drop foreign key fk_business_employeecore_user_core_user2;';

$updates['202112131426'][] = 'alter table business_manager
    add constraint fk_business_employeecore_user_core_user2
        foreign key (managerId) references core_user (id)
            on delete cascade;';

$updates['202112131426'][] = 'alter table business_agreement
    drop foreign key fk_business_agreement_business_employee1;';

$updates['202112131426'][] = 'alter table business_agreement
    add constraint fk_business_agreement_business_employee1
        foreign key (employeeId) references core_user (id)
            on delete cascade;';

$updates['202112131426'][] = 'alter table business_employee
    drop foreign key fk_business_employee_business_business1;';

$updates['202112131426'][] = 'alter table business_employee
    add constraint fk_business_employee_business_business1
        foreign key (businessId) references business_business (id)
            on delete cascade;';

$updates['202112131426'][] = 'alter table business_employee
    drop foreign key fk_business_employee_core_user1;';

$updates['202112131426'][] = 'alter table business_employee
    add constraint fk_business_employee_core_user1
        foreign key (id) references core_user (id)
            on delete cascade;';

$updates['202112160922'][] = "ALTER TABLE `business_agreement` ADD COLUMN `finish` DATE  DEFAULT NULL AFTER `start`;";

$updates['202112211030'][] = function() {
	// Fetch all employee agreements, sort by employeeId and start, both ascending
	$q1 = <<<SQL
SELECT DISTINCT `e`.`id` FROM `business_employee` `e` INNER JOIN `core_user` `u` ON `e`.`id` = `u`.`id`
INNER JOIN `business_agreement` `ba` ON `ba`.`employeeId` = `e`.`id`
WHERE `u`.`enabled` = 1
ORDER BY `u`.`id` ASC;
SQL;
	$employeeIds = go()->getDbConnection()->query($q1)->fetchAll();
	foreach($employeeIds as $employee) {
		$employeeId = $employee['id'];

		$q2 = go()->getDbConnection()->query("SELECT `id`,`start`, `finish` FROM `business_agreement` WHERE `employeeId` = " . $employeeId ." ORDER BY `start` ASC;");
		$a = $q2->fetch(PDO::FETCH_ASSOC);
		while($a) {
			$next = $q2->fetch(PDO::FETCH_ASSOC);
			// If the finish date is empty, try to fetch the next agreement

			if(empty($a['finish']) && $next) {
				// The current finish date is the next agreement start date minus one day
				$dt = new DateTime($next['start']);
				$dt->sub(new \DateInterval("P1D"));
				$a['finish'] = $dt->format('Y-m-d');
				$ag = \go\modules\business\business\model\EmployeeAgreement::findById($a['id']);
				$ag->finish = $dt;
				$ag->save();
			}
			$a = $next;
		}
	}
};

$updates['202201061627'][] = "alter table business_activity
    add sortOrder int(11) unsigned default 0 null;";




//Start finance

$updates['202201061627'][] = 'CREATE TABLE if not exists `business_business_vat_rate` (
`id` int(10) UNSIGNED NOT NULL,
  `businessId` int(10) UNSIGNED NOT NULL,
  `name` varchar(190) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rate` decimal(19,4) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;';

$updates['202201061627'][] = "INSERT INTO `business_business_vat_rate` (`id`, `businessId`, `name`, `rate`) VALUES
(3, 1, 'Standard', '21.0000'),
(4, 1, 'Reduced', '9.0000'),
(5, 1, 'Zero', '0.0000');";


$updates['202201061627'][] = "ALTER TABLE `business_business_vat_rate`
  ADD PRIMARY KEY (`id`),
  ADD KEY `businessId` (`businessId`);";


$updates['202201061627'][] = "ALTER TABLE `business_business_vat_rate`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;";


$updates['202201061627'][] = "ALTER TABLE `business_business_vat_rate`
  ADD CONSTRAINT `business_business_vat_rate_ibfk_1` FOREIGN KEY (`businessId`) REFERENCES `business_business` (`id`) ON DELETE CASCADE;";


$updates['202201061627'][] = "ALTER TABLE `business_business` ADD `defaultVatRateId` INT UNSIGNED NULL DEFAULT NULL AFTER `contactId`;";
$updates['202201061627'][] = "ALTER TABLE `business_business` ADD FOREIGN KEY (`defaultVatRateId`) REFERENCES `business_business_vat_rate`(`id`) ON DELETE SET NULL ON UPDATE RESTRICT;";


$updates['202201061627'][] = "alter table business_business
	add aclId int default null;";

$updates['202201061627'][] = "alter table business_business
	add constraint business_business_core_acl_id_fk
		foreign key (aclId) references core_acl (id);";

$updates['202201061627'][] = function() {
	$businesses = \go\modules\business\business\model\Business::find();
	foreach ($businesses as $business) {
		$business->setAcl([
			\go\core\model\Group::ID_INTERNAL => \go\core\model\Acl::LEVEL_READ
		]);
		if(!$business->save()) {
			throw new \go\core\orm\exception\SaveException($business);
		}
	}
};

$updates['202201061627'][] = "alter table business_business modify aclId int not null;";

