go.modules.business.finance.FinanceBookDialog = Ext.extend(go.form.Dialog, {
	stateId: 'finance-book-dialog',
	title: t('Book'),
	entityStore: "FinanceBook",
	titleField: "name",
	width: dp(800),
	height: dp(600),

	onReady: function() {
		this.enableTemplates();
		this.supr().onReady.call(this);

		if(!this.currentId) {
			this.formPanel.form.findField("businessId").selectFirst();
		}
	},

	onSubmit: function() {
		if(this.pdfTemplatesGrid.disabled) {
			this.closeOnSubmit = false;
			this.enableTemplates();

			this.pdfTemplatesGrid.show();
			setTimeout(() => {
				this.closeOnSubmit = true;
			});
		}

		this.supr().onSubmit.call(this);
	},

	enableTemplates: function() {
		if(this.currentId) {
			this.pdfTemplatesGrid.setDisabled(false);
			this.pdfTemplatesGrid.setKey( "fb-def-" + this.currentId  );
			this.pdfTemplatesGrid.store.load();

			this.extraPdfTemplatesGrid.setDisabled(false);
			this.extraPdfTemplatesGrid.setKey( "fb-xtr-" + this.currentId  );
			this.extraPdfTemplatesGrid.store.load();

			this.emailTemplatesGrid.setDisabled(false);
			this.emailTemplatesGrid.setKey( "fb-def-" + this.currentId  );
			this.emailTemplatesGrid.store.load();

			this.extraEmailTemplatesGrid.setDisabled(false);
			this.extraEmailTemplatesGrid.setKey( "fb-xtr-" + this.currentId  );
			this.extraEmailTemplatesGrid.store.load();
		}
	},

	initFormItems: function () {

		this.addPanel(new go.permissions.SharePanel());

		this.addPanel(new go.modules.business.finance.FinanceStatusGrid ());

		this.pdfTemplatesGrid = new go.pdftemplate.GridPanel({
			disabled: true,
			border: 1,
			title: t("Default"),
			module: {
				name: "finance",
				package: "business"
			},
			hideLabel: true
		});

		this.extraPdfTemplatesGrid = new go.pdftemplate.GridPanel({
			disabled: true,
			border: 1,
			title: t("Additional"),
			module: {
				name: "finance",
				package: "business"
			},
			hideLabel: true
		});

		this.addPanel({
			title: t("PDF Templates"),
			items: [
				{
					xtype: "fieldset",
					items: [this.pdfTemplatesGrid]
				},
				{
					xtype: "fieldset",
					items: [this.extraPdfTemplatesGrid]
				}
			]
		});

		this.emailTemplatesGrid = new go.emailtemplate.GridPanel({
			disabled: true,
			border: 1,
			title: t("Default"),
			module: {
				name: "finance",
				package: "business"
			},
			templateDefaults: {
				subject: "{{template.name}} {{document.number}}[if {{document.reference}}] - {{document.reference}}[/if]"
			},
			hideLabel: true
		});

		this.extraEmailTemplatesGrid = new go.emailtemplate.GridPanel({
			disabled: true,
			border: 1,
			title: t("Additional"),
			module: {
				name: "finance",
				package: "business"
			},
			templateDefaults: {
				subject: "{{template.name}} {{document.number}}[if {{document.reference}}] - {{document.reference}}[/if]"
			},
			hideLabel: true
		});

		this.addPanel({
			title: t("E-mail Templates"),
			items: [
				{
					xtype: "fieldset",
					items: [this.emailTemplatesGrid]
				},
				{
					xtype: "fieldset",
					items: [this.extraEmailTemplatesGrid]
				}
			]
		});

		return [{
			xtype: 'fieldset',
			items: [
				{
					xtype: "businesscombo"
				},

				{
					xtype: "selectfield",
					hiddenName: "type",
					fieldLabel: t("Type"),
					value: "quote",
					options: [
						['quote', t('Quotes')],
						['salesorder', t('Sales orders')],
						['purchaseorder', t('Purchase orders')],
						['purchaseinvoice', t('Purchase invoices')],
						['salesinvoice', t('Sales invoices')],
						['payments', t('Payments')]
					],
					listeners: {
						change: function(f, v, old) {
							const nameF = this.formPanel.form.findField("name");
							if(!nameF.isDirty() || nameF.getValue() == f.store.getById(old).data.text) {
								nameF.setValue(f.store.getById(v).data.text);
							}
						},
						scope: this
					}
				},


				{
					xtype: 'textfield',
					name: 'name',
					fieldLabel: t("Name"),
					anchor: '100%',
					allowBlank: false,
					value: t('Quotes')
				},

				{
					xtype: "textfield",
					name: "numberFormat",
					fieldLabel: t("Number format"),
					value: "%T%Y-00000"
				},
				{
					xtype: "numberfield",
					decimals: 0,
					name: "nextNumber",
					fieldLabel: t("Next number"),
					value: 1
				},
				{
					xtype: "textfield",
					name: "currency",
					fieldLabel: t("Currency"),
					value: go.User.currency
				},

				new go.form.RadioGroup({
					anchor: '100%',
					xtype: 'radiogroup',
					fieldLabel: t("Business model"),
					name: "businessModel",
					value: null,
					items: [
						{boxLabel: t("B2B"), inputValue: 'b2b'},
						{boxLabel: t("B2C"), inputValue: 'b2c'},
						{boxLabel: t("Both"), inputValue: 'both'}
					]
				}),

				{
					fieldLabel: t("Greeting"),
					xtype: 'gohtmleditor',
					name: 'defaultGreeting',
					anchor: "100%",
					grow: true
				},

				{
					fieldLabel: t("Closing"),
					xtype: 'gohtmleditor',
					name: 'defaultClosing',
					anchor: "100%",
					grow: true
				}

			]
		}
		];
	}
});
