go.modules.business.finance.FinanceBookGrid = Ext.extend(go.NavGrid, {

	initComponent: function () {


		Ext.apply(this, {
			singleSelect: true,
			selectFirst: true,
			menuItems: [
				{
					itemId: "edit",
					iconCls: 'ic-edit',
					text: t("Edit"),
					handler: function() {
						var dlg = new go.modules.business.finance.FinanceBookDialog();
						dlg.load(this.moreMenu.record.id).show();
					},
					scope: this
				},{
					itemId: "delete",
					iconCls: 'ic-delete',
					text: t("Delete"),
					handler: function() {
						Ext.MessageBox.confirm(t("Confirm delete"), t("Are you sure you want to delete this item?"), function (btn) {
							if (btn != "yes") {
								return;
							}
							go.Db.store("FinanceBook").set({destroy: [this.moreMenu.record.id]});
						}, this);
					},
					scope: this
				}
			],

			store: new go.data.Store({
				fields: ['id', 'name', 'permissionLevel'],
				entityStore: "FinanceBook",
				limit: 0,
				sortInfo: {
					field: "name"
				}
			}),

			stateful: true
		});

		go.modules.business.finance.FinanceBookGrid.superclass.initComponent.call(this);

		this.on('beforeshowmenu', (menu, record) => {
			menu.getComponent("edit").setDisabled(record.get("permissionLevel") < go.permissionLevels.manage);
			menu.getComponent("delete").setDisabled(record.get("permissionLevel") < go.permissionLevels.manage);
		});
	}
});
