import {AutocompleteField, Config, createComponent, listStoreType, storeRecordType, t} from "@intermesh/goui";
import {TasklistTable} from "./TasklistTable.js";
import {FilterCondition, jmapds} from "@intermesh/groupoffice-core";

export class TasklistCombo extends AutocompleteField<TasklistTable> {


	pickerRecordToValue(field: this, record: storeRecordType<listStoreType<TasklistTable>>): string {
		return record.id;
	}

	async valueToTextField(field: this, value: string): Promise<string> {
		const entityStore = jmapds("TaskList");
		const nb = await entityStore.single(value);

		return nb ? nb.name : "?";
	}

	constructor() {
		super(new TasklistTable());

		this.label = t("Tasklist", "community", "tasks");
		this.name = "tasklistId";

		this.on("autocomplete", async (field, input) => {
			(this.list.store.queryParams.filter as FilterCondition).text = input;
			await this.list.store.load();
		});
	}
}

export const tasklistcombo = (config?: Config<TasklistCombo>) => createComponent(new TasklistCombo(), config);