/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { FindComponentPredicate } from "./Component.js";
import { DraggableComponent } from "./DraggableComponent.js";
import { Config } from "./Observable";
/**
 * Splitter
 *
 * Used to resize panels
 */
export declare class Splitter extends DraggableComponent {
    private resizeComponentPredicate;
    private _resizeComponent?;
    /**
     * Resize the widths when this hr is styled as a vertical splitter, otherwise the height is set.
     */
    resizeWidth?: boolean;
    /**
     * When the panel is on the left of a center panel that auto sizes. The x offset can be added to the width. But if
     * the panel is on the right the x offset must be inverted.
     * If not given the splitter will auto detect it's position relative to the component it resizes
     */
    invert?: boolean;
    /**
     * The minimum size it will set. Note that you can also put a min-width or min-height on the element with css.
     */
    minSize: number;
    /**
     * The maximim size it will set. Note that you can also put a max-width or max-height on the element with css.
     */
    maxSize?: number;
    /**
     *
     * @param resizeComponentPredicate 	The component to resize in height or width.
     *    Can be a component ID, itemId property, Component instance or custom function
     *
     */
    constructor(resizeComponentPredicate: FindComponentPredicate);
    private findResizeComponent;
    private applyStateToResizeComp;
    protected buildState(): {
        width: number;
        height?: undefined;
    } | {
        height: number;
        width?: undefined;
    };
    protected internalRender(): HTMLElement;
}
type SplitterConfig = Config<Splitter> & {
    resizeComponentPredicate: FindComponentPredicate;
};
/**
 * Shorthand function to create {@see Splitter}
 */
export declare const splitter: (config: SplitterConfig) => Splitter;
export {};
//# sourceMappingURL=Splitter.d.ts.map