import { Component, createComponent } from "../Component";
export class ListPicker extends Component {
    constructor(list) {
        super();
        this.list = list;
        this.list.rowSelectionConfig = { multiSelect: false };
        // this.list.fitParent = true;
        this.items.add(list);
        // set value on click and enter
        this.list.on("rowclick", (table, rowIndex, row, ev) => {
            this.onSelect();
        });
        this.list.on("hide", () => {
            this.list.rowSelection.clear();
        });
        //datachanged fires for each row. With buffer = 0 only fires once at load
        this.list.store.on("datachanged", () => {
            if (this.list.store.count() > 0) {
                this.list.rowSelection.selected = [0];
            }
        }, { buffer: 0 });
        // stop clicks on menu from hiding menu
        this.list.el.addEventListener("mousedown", (ev) => {
            ev.stopPropagation();
        });
        this.list.el.addEventListener('keydown', (ev) => {
            switch (ev.key) {
                case "Enter":
                    ev.preventDefault();
                    this.onSelect();
                    break;
            }
        });
    }
    focus(o) {
        this.list.focus(o);
    }
    onSelect() {
        const selected = this.list.rowSelection.selected;
        if (selected.length) {
            this.fire("select", this, this.list.store.get(selected[0]));
        }
    }
}
// type ListPickerConfig<ListType extends List>  =
// 	Omit<Config<
// 		ListPicker<ListType>,
// 		ListPickerEventMap<ListPicker<ListType>>
// 	>, "list">
// 	&
// 	{
// 		list: ListType
// 	}
/**
 * Shorthand function to create {@see Table}
 *
 * @param config
 */
export const listpicker = (config) => createComponent(new ListPicker(config.list), config);
//# sourceMappingURL=ListPicker.js.map