import { CardContainer, Component, DataSourceForm, EntityID, Listener, ObservableListenerOpts, Window, WindowEventMap } from "@intermesh/goui";
import { SharePanel } from "../permissions";
/**
 * @inheritDoc
 */
export interface FormWindowEventMap<Type> extends WindowEventMap<Type> {
    /**
     * Fires when the window is shown and loaded with data. Also fires if the dialog is for creating new entities and
     * not loaded.
     *
     * @param window
     */
    ready: (window: Type, currentId: string | undefined) => void;
}
export interface FormWindow {
    on<K extends keyof FormWindowEventMap<this>, L extends Listener>(eventName: K, listener: Partial<FormWindowEventMap<this>>[K], options?: ObservableListenerOpts): L;
    un<K extends keyof FormWindowEventMap<this>>(eventName: K, listener: Partial<FormWindowEventMap<this>>[K]): boolean;
    fire<K extends keyof FormWindowEventMap<this>>(eventName: K, ...args: Parameters<FormWindowEventMap<any>[K]>): boolean;
}
export declare abstract class FormWindow extends Window {
    entityName: string;
    readonly form: DataSourceForm;
    protected currentId?: EntityID;
    protected readonly cards: CardContainer;
    protected sharePanel?: SharePanel;
    /**
     * The first tab
     *
     * @protected
     */
    protected readonly generalTab: Component;
    private cardMenu;
    /**
     * Constructor
     *
     * @param entityName Name of the entity for the datasource form
     * @protected
     */
    protected constructor(entityName: string);
    private closeWithModifications;
    protected onBeforeClose(): boolean | undefined;
    protected onShow(): void;
    /**
     * Add a share panel to set permissions
     *
     * @params options if not provided the default is:
     * [
     * 	{value: "", name: ""},
     * 	{value: 10, name: t("Read")},
     * 	{value: 20, name: t("Create")},
     * 	{value: 30, name: t("Write")},
     * 	{value: 40, name: t("Delete")},
     * 	{value: 50, name: t("Manage")}
     * ]
     */
    protected addSharePanel(levels?: {
        [key: string]: any;
    }[]): void;
    load(id: EntityID): Promise<this>;
    protected addCustomFields(): void;
    private renderCustomFields;
    /**
     * Adds a link between two entities on save.
     *
     * @param {string} entityName - The name of the target entity.
     * @param {string} entityId - The ID of the target entity.
     * @return {void}
     */
    addLinkOnSave(entityName: string, entityId: string): void;
}
//# sourceMappingURL=FormWindow.d.ts.map