import { List, ListEventMap, RowRenderer } from "./List";
import { Store, StoreRecord } from "../data";
import { Config, Listener, ObservableListenerOpts } from "./Observable";
import { MaterialIcon } from "./MaterialIcon";
export declare const TreeRowRenderer: RowRenderer;
export interface TreeEventMap<Type> extends ListEventMap<Type> {
    /**
     * Fires when a node expands
     *
     * @param tree The main tree
     * @param childrenTree The tree component that will load the children of the expanding ndoe
     * @param record The record of the expanding node
     * @param storeIndex The index of the record in the store
     */
    expand: (tree: Type, childrenTree: Type, record: StoreRecord | undefined, storeIndex: number) => void;
    /**
     * Fires when a node collapses
     *
     * @param tree The main tree
     * @param childrenTree The tree component that will load the children of the collapsing ndoe
     * @param record The record of the collapsing node
     * @param storeIndex The index of the record in the store
     */
    collapse: (tree: Type, childrenTree: Type, record: StoreRecord, storeIndex: number) => void;
    /**
     * Fires when a node collapses
     *
     * @param tree The main tree
     * @param childrenTree The tree component that will load the children of the collapsing ndoe
     * @param record The record of the collapsing node
     * @param storeIndex The index of the record in the store
     */
    checkchange: (tree: Type, childrenTree: Type, record: StoreRecord, storeIndex: number, checked: boolean) => void;
}
export interface Tree extends List<Store<TreeRecord>> {
    on<K extends keyof TreeEventMap<this>, L extends Listener>(eventName: K, listener: Partial<TreeEventMap<this>>[K], options?: ObservableListenerOpts): L;
    un<K extends keyof TreeEventMap<this>>(eventName: K, listener: Partial<TreeEventMap<this>>[K]): boolean;
    fire<K extends keyof TreeEventMap<this>>(eventName: K, ...args: Parameters<TreeEventMap<any>[K]>): boolean;
}
export type TreeRecord = {
    /**
     * Unique ID of the node
     */
    id: string;
    /**
     * Text of the node
     */
    text: string;
    /**
     * Child nodes. If not present then it can be populated on the "expand" event.
     */
    children?: TreeRecord[];
    /**
     * Icon to display
     */
    icon?: MaterialIcon;
    /**
     * CSS class for the node
     */
    cls?: string;
    /**
     * If set a checkbox will render
     */
    check?: boolean;
};
export declare class Tree extends List<Store<TreeRecord>> {
    readonly renderer: RowRenderer;
    private subTrees;
    private dragOverTimeout?;
    private expandedIds;
    private parentStoreIndex;
    constructor(renderer?: RowRenderer);
    set data(records: TreeRecord[]);
    /**
     * The full hierarchical store data of the tree
     */
    get data(): TreeRecord[];
    /**
     * Reload the tree if loaded via the "expand" event.
     */
    reload(): void;
    private fireExpand;
    /**
     * Find the first menu in the tree of submenu's
     */
    findTopTree(): Tree;
    private expand;
    private renderSubTree;
    private collapse;
    protected renderRow(record: any, storeIndex: number): HTMLElement;
    protected onNodeDragEnterAllowed(e: DragEvent, dropRow: HTMLElement): void;
    protected onNodeDragLeaveAllowed(e: DragEvent, dropRow: HTMLElement): void;
    protected dropAllowed(e: DragEvent, dropRow: HTMLElement): any;
    protected onNodeDrop(e: DragEvent): false | undefined;
}
type TreeConfig = Omit<Config<Tree, TreeEventMap<Tree>>, "rowSelection">;
/**
 * Shorthand function to create {@see Table}
 *
 * @param config
 */
export declare const tree: (config: TreeConfig) => Tree;
export {};
//# sourceMappingURL=Tree.d.ts.map