import { createComponent } from "../Component.js";
import { InputField } from "./InputField";
/**
 * Text Area component
 *
 * @see Form
 */
export class TextAreaField extends InputField {
    constructor() {
        super(...arguments);
        this.baseCls = 'goui-form-field textarea';
    }
    createInput() {
        //grab value before creating this.input otherwise it will return the input value
        const input = document.createElement("textarea");
        if (this.autoHeight) {
            input.rows = 1;
            input.style.overflowY = 'hidden';
            input.on('input', (ev) => {
                this.resize(input);
            });
            this.on('setvalue', () => { this.resize(input); });
        }
        return input;
    }
    resize(input) {
        input.style.height = "0";
        input.style.height = (input.scrollHeight) + "px";
    }
}
/**
 * Shorthand function to create {@see TextAreaField}
 *
 * @param config
 */
export const textarea = (config) => createComponent(new TextAreaField(), config);
//# sourceMappingURL=TextareaField.js.map