import { createComponent } from "../Component";
import { DateTime } from "../../util";
import { InputField } from "./InputField";
/**
 * TimeField component
 *
 * Time input based on the browsers locale. Outputs time in "H:i" format. eg. 09:30 or 15:30 {@link DateTime.format}
 *
 * @link https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input/time
 */
export class TimeField extends InputField {
    constructor() {
        super();
        this.baseCls = "goui-form-field time no-floating-label";
        this.type = "time";
    }
    set step(v) {
        this.input.step = v.toString();
    }
    get step() {
        return parseInt(this.input.step);
    }
    /**
     * The minimum number allowed
     * @param min
     */
    set min(min) {
        this.input.attr('min', min);
    }
    get min() {
        return this.input.attr('min');
    }
    /**
     * The maximum number allowed
     *
     * @param max
     */
    set max(max) {
        this.input.attr('max', max);
    }
    /**
     * Get the date as DateTime object
     */
    getValueAsDateTime() {
        let v = this.value;
        let date;
        if (!v || !(date = DateTime.createFromFormat(v, "Y-m-dTH:i"))) {
            return undefined;
        }
        return date;
    }
}
/**
 * Shorthand function to create {@see TextField}
 *
 * @param config
 */
export const timefield = (config) => createComponent(new TimeField(), config);
//# sourceMappingURL=TimeField.js.map