Ext.define('go.modules.business.business.BusinessDialog',{
	extend: go.form.Dialog,
	
	stateId: 'business-DialogForm',
	title: t('Business'),
	entityStore: "Business",
	// autoHeight: true,
	height: dp(800),
	width: dp(500),
	initFormItems: function () {

		this.addPanel(new go.permissions.SharePanel());

		return [{
			xtype: 'fieldset',
			items: [new go.modules.community.addressbook.ContactCombo({
				hiddenName: 'contactId',
				fieldLabel: t('Organization', 'addressbook', 'community'),
				isOrganization: true,
				listeners: {
					'select':function(combo, record, index){
						this.nameField.setValue(record.data.name);
					},
					scope:this
				}
			}),this.nameField = new Ext.form.TextField({
				name: 'name',
				fieldLabel: t("Name"),
				anchor: '100%',
				required: true
			}),{
				xtype: 'numberfield',
				name: 'hourlyRevenue',
				fieldLabel: t("Hourly revenue"),
				anchor: '100%',
				required: true,
				value: 0
			},{
				xtype: "fieldset",
				title: t("VAT rates"),
				items: [
					{
						xtype: "formgroup",
						name: "vatRates",

						itemCfg: {
							items: [{
								xtype: "compositefield",
								hideLabel: true,
								items: [{
									xtype: "hidden",
									name: "id" //for keeping records
								}, {
									flex: 4,
									xtype: "textfield",
									allowBlank: false,
									name: "name"
								}, {
									flex: 2,
									name: "rate",
									xtype: "gonumberfield",
									value: 0
								}]
							}]
						}
					}
				]
			}]
		}];
	}
});
