import {BaseEntity, ComboBox, Config, createComponent, t} from "@intermesh/goui";
import {jmapds} from "@intermesh/groupoffice-core";

interface Business extends BaseEntity {
	name:string
}

export class BusinessCombo extends ComboBox {

	constructor() {

		super(jmapds<Business>("Business"));

		this.label = t("Business", "business", "business");
		this.name = "businessId";
		this.filterName = "text";
	}
}

export const businesscombo = (config?: Config<BusinessCombo>) => createComponent(new BusinessCombo(), config);