go.Modules.register("business", "catalog", {
	mainPanel: "go.modules.business.catalog.MainPanel",
	title: t("Catalog"),
	entities: [{
		name: "Article",
		relations: {
			creator: { store: "User", fk: "createdBy" },
			modifier: { store: "User", fk: "createdBy" },
			business: { store: "Business", fk: "createdBy" },
			supplier: { store: "Contact", fk: "supplierOrganizationId" }
		},
		filters: [{
			name: 'text',
			type: "string",
			multiple: false,
			title: t("Query")
		},{
			title: t("Modified at"),
			name: 'modifiedat',
			multiple: false,
			type: 'date'
		},{
			title: t("Modified by"),
			name: 'modifiedBy',
			multiple: true,
			type: 'string'
		},{
			title: t("Created at"),
			name: 'createdat',
			multiple: false,
			type: 'date'
		},{
			title: t("Created by"),
			name: 'createdby',
			multiple: true,
			type: 'string'
		}, {
			title: t("Supplier"),
			name: 'supplierOrganizationId',
			multiple: true,
			type: "contactcombo",
			typeConfig: {
				isOrganization: true
			}
		}],
		links: [{
			iconCls: 'entity ic-note',
			linkWindow: function (entity, entityId) {
				return new go.modules.business.catalog.ArticleDialog();
			},
			linkDetail: function () {
				return new go.modules.business.catalog.ArticleDetail();
			}
		}]
	}],
	initModule: function () {

	}
});

