go.modules.business.fileconverter.SystemSettingsPanel = Ext.extend(go.systemsettings.Panel, {

    initComponent: function () {

        Ext.apply(this, {
            title: t('Converter', 'fileconverter', 'business'),
            autoScroll: true,
            iconCls: 'ic-compare-arrows',
            items: [
                {
                    xtype: 'fieldset',
                    title: t('Service'),
                    defaults: {
                        anchor: '100%',
                    },
                    items: [
                        this.serviceType = new go.form.ComboBox({
                            xtype: 'gocombo',
                            fieldLabel: t('Service Type'),
                            name: "serviceType",
                            store: new Ext.data.ArrayStore({
                                fields: ['value', 'text', 'fields'],
                                data: [
                                    ['libreoffice', t('LibreOffice', 'fileconverter', 'business'), ['serviceUri']],
                                    ['convertio', t('Convertio', 'fileconverter', 'business'), ['apiKey']],
                                    ['onlyoffice', t('OnlyOffice', 'fileconverter', 'business'), ['serviceUri']],
                                ],
                            }),
                            valueField: 'value',
                            displayField: 'text',
                            mode: 'local',
                            triggerAction: 'all',
                            editable: false,
                            selectOnFocus: true,
                            forceSelection: true,
                            listeners: {
                                beforeselect: function (combo) {
                                    combo.previousValue = combo.getValue();
                                },
                                select: function (combo, newVal) {
                                    if (combo.previousValue !== newVal) {
                                        this.updateFieldsVisibility();
                                    }
                                },
                                scope: this
                            }
                        }),
                        {
                            xtype: 'textfield',
                            fieldLabel: t('Service Uri', 'fileconverter', 'business'),
                            name: 'serviceUri',
                            hidden: true,
                        },
                        {
                            xtype: 'textfield',
                            fieldLabel: t('API Key', 'fileconverter', 'business'),
                            name: 'apiKey',
                            hidden: true,
                        },
                    ]
                },
            ]
        });

        go.modules.business.fileconverter.SystemSettingsPanel.superclass.initComponent.call(this);
    },

    afterRender: function() {
        go.modules.business.fileconverter.SystemSettingsPanel.superclass.afterRender.call(this);

        this.updateFieldsVisibility();
    },

    updateFieldsVisibility: function () {
        let serviceTypeValue = this.serviceType.getValue(),
            serviceTypeStore = this.serviceType.getStore(),
            serviceTypeRecord = serviceTypeStore.getAt(serviceTypeStore.findExact('value', serviceTypeValue)),
            form = this.getForm(),
            fields = ['serviceUri', 'apiKey'];

        //hide fields
        Ext.each(fields, function(field) {
            form.findField(field).setVisible(false);
        }, this);

        //show related
        Ext.each(serviceTypeRecord.get('fields'), function(field) {
            form.findField(field).setVisible(true);
        }, this);
    },
});