(function(){
	let businesses;
	GO.mainLayout.on('authenticated', () => {

		if(go.Modules.isAvailable("business", "finance") && go.Modules.isAvailable("business", "business")) {
			businesses = go.Db.store("Business").all();
		}

	});

	go.modules.business.finance.BusinessesFieldSet = Ext.extend(go.form.FormContainer, {
		name: "businesses",

		loaded: null,

		load: function () {

			if(this.loaded || !businesses) {
				return this.loaded;
			}

			Ext.getBody().mask(t("Loading..."));

			this.loaded = businesses.then((businesses) => {
				businesses.forEach((biz) => {
					this.add(
						new go.form.FormContainer({
							hideLabel: true,
							name: biz.id,
							items: [
								new Ext.form.FieldSet({
									hideLabel: true,
									title: biz.name,
									items: [
										new go.modules.business.finance.BusinessesFieldSet.DebtorProfileCombo()
									]
								})
							]
						})
					)

				})

				this.doLayout();
			}).finally(() => {
				Ext.getBody().unmask();
			});

			return this.loaded;

		}
	});
})();