
go.modules.business.finance.ItemsField = Ext.extend(go.form.FormGroup, {
	xtype: "formgroup",
	sortable: true,
	sortColumn: "order",
	name: "items",
	addButtonText: t("Add item"),
	headers: true,
	required: true,
	decimals: 2,

	showPriceIncl: false,

	vatRateId: undefined,

	initComponent: function() {

		this.buildItemConfig();

		go.modules.business.finance.ItemsField.superclass.initComponent.call(this);

	},

	togglePriceIncl: function(show) {

		this.showPriceIncl = show;

		const index = go.Modules.isAvailable("business", "catalog") ? 5 : 4;

		//unit price
		this.itemCfg.items[0].items[index].hidden = this.showPriceIncl;
		this.itemCfg.items[0].items[index].decimals = this.showPriceIncl ? 10 : this.decimals;
		//unitPriceIncl
		this.itemCfg.items[0].items[index + 1].hidden = !this.showPriceIncl;

		this.setValue(this.getValue());

		if(this.items.getCount() == 0) {
			this.addPanel(true);
		}
	},


	buildItemConfig : function() {
		this.itemCfg = {
			columnWidth: 1,
			xtype: "formcontainer",
			listeners: {
				afterlayout: function(formContainer) {
					const formDialog = formContainer.findParentByType("formdialog");

					const unitCostField = formContainer.findField("unitCost"), marginField = formContainer.findField("margin");

					if(formDialog.type != "purchaseinvoice" && formDialog.type != "purchaseorder" && formDialog.type != "contract") {
						unitCostField.show();
						unitCostField.setDisabled(false);
						marginField.show();
					}else
					{
						unitCostField.hide();
						unitCostField.setDisabled(true);
						marginField.hide();
					}

				}
			},
			items: [{
				xtype: "container",
				layout: "form",
				cls: "go-hbox",
				items: [{
					xtype: "hidden",
					name: "id" //for keeping records
				},{
					flex: 1,
					name: "quantity",
					xtype: "gonumberfield",
					setFocus: true,
					value: 1,
					fieldLabel: t("Quantity"),
					decimals: this.decimals
				}, {
					fieldLabel: t("Description"),
					flex: 4,
					xtype: "textarea",
					//height: dp(48),
					allowBlank: false,
					grow: true,
					name: "description",
					growMin : dp(24),
					height: dp(24),
					// listeners: {
					// 	afterrender: function(field) {
					// 		field.grow = false;
					// 		field.setHeight(dp(24));
					// 		field.lastHeight = dp(24);
					// 		field.ownerCt.setHeight(dp(24));
					// 	},
					// 	focus: function(field) {
					// 		field.grow = true;
					// 		field.autoSize();
					// 		field.ownerCt.setHeight(field.getHeight());
					// 	},
					// 	blur: function(field) {
					// 		field.grow = false;
					// 		field.setHeight(dp(24));
					// 		field.lastHeight = dp(24);
					// 		field.ownerCt.setHeight(dp(24))
					// 	},
					// 	autosize: function (field, h) {
					// 		//needed for making hbox layout grow along
					// 		field.ownerCt.setHeight(h);
					// 	}
					// }

				},{
					itemId: "unitCost",
					fieldLabel: t("Unit cost"),
					flex: 2,
					name: "unitCost",
					xtype: "gonumberfield",
					value: 0,
					decimals: this.decimals,
					listeners: {
						scope: this,
						change: function(field, v) {

							if(!v) {
								return;
							}

							const unitCost = field.ownerCt.items.get("unitCost").getValue();

							const margin = field.ownerCt.items.get("margin").getValue();

							const unitPriceFld = field.ownerCt.items.get("unitPrice");

							unitPriceFld.setValue(unitCost * (100 + margin) / 100)
						}
					},

				}, {
					itemId: "unitPrice",
					fieldLabel: t("Unit price"),
					flex: 2,
					name: "unitPrice",
					xtype: "gonumberfield",
					listeners: {
						scope: this,
						change: (field, v) => {

							this.updatePriceIncl(field.ownerCt);

							this.updateMarginFromUnitPrice(field.ownerCt);


						}
					},
					value: 0,
					hidden: this.showPriceIncl,
					decimals: this.showPriceIncl ? 10 : this.decimals
				}, {
					hidden: !this.showPriceIncl,
					itemId: "unitPriceIncl",
					submit: false,
					fieldLabel: t("Price Incl."),
					flex: 2,
					name: "unitPriceIncl",
					xtype: "gonumberfield",
					listeners: {
						scope: this,
						render: (field) => {

							this.updatePriceIncl(field.ownerCt);


						},
						change: (field, v) => {
							const unitPrice = field.ownerCt.items.get("unitPrice");

							if(!unitPrice) {
								return;
							}

							const vatRateId = field.ownerCt.items.get("vatRate").getValue(),
								vatRate =	vatRateId ? go.modules.business.finance.stores.vatRateStore.getById(vatRateId).data.rate : 0;

							unitPrice.setValue( field.getValue() * 100 / (100 + vatRate));

							this.updateMarginFromUnitPrice(field.ownerCt);
						}
					},
					value: 0,
					decimals: this.decimals
				},
					{
						itemId: "margin",
						submit: false,
						fieldLabel: t("Margin"),
						flex: 1,
						name: "margin",
						xtype: "gonumberfield",
						value: 0,
						listeners: {
							scope: this,
							render: function(field) {

								const unitCost = field.ownerCt.items.get("unitCost").getValue();
								if(!unitCost) {
									return;
								}
								const unitPrice = field.ownerCt.items.get("unitPrice").getValue();

								field.setValue((unitPrice / unitCost ) * 100 - 100);


							},
							change: function(field, v) {
								const unitCost = field.ownerCt.items.get("unitCost").getValue();

								if(!unitCost) {
									return;
								}

								const unitPriceFld = field.ownerCt.items.get("unitPrice");

								unitPriceFld.setValue(unitCost * (100 + v) / 100);

								this.updatePriceIncl(field.ownerCt);
							}
						},
						decimals: 0
					},

					{
						flex: 2,
						xtype: "vatratecombo",
						itemId: 'vatRate',
						fieldLabel: t("VAT rate"),
						value: this.vatRateId,
						store: go.modules.business.finance.stores.vatRateStore,
						listeners: {
							scope: this,
							render: function(cmp) {

								if(!cmp.getValue()) {
									cmp.setValue(this.vatRateId);
								}

								go.modules.business.finance.stores.vatRateStore.on("load", this.onLoadFn = function() {

									// sometimes the component has been replaced by loading the dialog.
									if(cmp.isDestroyed) {
										return;
									}

									if(!cmp.getValue()) {
										const first = cmp.store.getAt(0);
										if(first) {
											cmp.setValue(first.id);
											cmp.originalValue = first.id; // for dirty check
										}
									} else
									{
										//for rendering the text
										cmp.setValue(cmp.getValue());
									}
								});
							},
							destroy:function(cmp) {
								go.modules.business.finance.stores.vatRateStore.un("load", this.onLoadFn);
							},
							change: function(field) {
								this.updatePriceIncl(field.ownerCt);
							}

						}
					}]
			}]
		};

		if(go.Modules.isAvailable("business", "catalog")) {

			this.itemCfg.items[0].items.splice(2, 0, {
				xtype: "articlecombo",
				flex: 3,
				listeners: {
					change: function(combo, articleId) {
						var record = combo.store.getById(articleId);
						var fc = combo.findParentByType("formcontainer");

						const vatRate =	record.data.vatRateId ? go.modules.business.finance.stores.vatRateStore.getById(record.data.vatRateId).data.rate : 0;


						fc.setValue({
							description:  (record.data.number ? record.data.number + " - " : "") +
								record.data.name,
							vatRateId: record.data.vatRateId,
							unitCost: record.data.cost,
							unitPrice: record.data.price,
							unitPriceIncl: record.data.price * (100 + vatRate) / 100,
							margin: record.data.cost ? ( record.data.price / record.data.cost ) * 100 - 100 : 0
						});

						fc.findField("vatRateId")
							.setValue(record.data.vatRateId);
					}
				}
			})
		}
	},

	updatePriceIncl : function(row) {

		const unitPrice = row.items.get("unitPrice"), unitPriceIncl = row.items.get("unitPriceIncl")

		if(!unitPrice) {
			return;
		}

		const vatRateId = row.items.get("vatRate").getValue();

		const	vatRate =	vatRateId ? go.modules.business.finance.stores.vatRateStore.getById(vatRateId).data.rate : 0;

		unitPriceIncl.setValue( unitPrice.getValue() *  (100 + vatRate) / 100);


	},

	updateMarginFromUnitPrice : function(row) {
		const unitCost = row.items.get("unitCost").getValue();
		const unitPrice = row.items.get("unitPrice"), unitPriceIncl = row.items.get("unitPriceIncl")

		if (!unitCost) {
			return;
		}

		const marginFld = row.items.get("margin");

		marginFld.setValue((unitPrice.getValue() / unitCost) * 100 - 100);
	}

});

Ext.reg("financeitemsfield", go.modules.business.finance.ItemsField);