go.modules.business.finance.FinanceDocumentLinkDetail = Ext.extend(go.modules.business.finance.FinanceDocumentGrid , {
	autoHeight: true,
	maxHeight: dp(300),
	title: t("Sales invoice"),
	stateId: "link-sales-invoice-list",
	collapsible: true,

	initComponent : function() {
		this.link  = {
			entity: null,
			filter: null
		};

		this.supr().initComponent.call(this);

		this.store.on("datachanged" , () => {
			this.setVisible(this.store.getCount() > 0);
		});

		this.on('rowdblclick', (grid, rowIndex) => {

			const record = grid.store.getAt(rowIndex);

			this.open(record.id);
		});
	},


	onLinkChanges: function(store, added, changed, detroyed)  {
		if(!this.store.loaded || this.store.loading || !this.store.lastOptions) {
			return;
		}

		this.store.reload();
	},

	onLoad: function (dv) {

		this.detailView = dv;
		this.hide();

		if(dv.entityStore && dv.entityStore.entity.name == "Contact") {
			this.store.setFilter("link", {
				customerId: dv.currentId
			});
		} else {
			this.store.setFilter("link", {
				link: {
					entity: dv.entity ? dv.entity : dv.entityStore.entity.name, //dv.entity exists on old DetailView or display panels
					id: dv.model_id ? dv.model_id : dv.currentId //model_id is from old display panel
				}
			})
		}
		this.store.baseParams.position = 0;
		this.store.load();
	},

	open : (id) => {

		go.Router.goto("FinanceDocument/" + id)
		// const win = new go.links.LinkDetailWindow({
		// 	entity: "FinanceDocument"
		// });
		//
		// win.load(id);
	}
});