Ext.define('go.modules.business.support.SystemSettingsPanel',{
	extend: go.systemsettings.Panel,

	layout: 'fit',
	title: t("Support"),
	iconCls: 'ic-support',

	initComponent: function () {

		this.tasklistGrid = new go.grid.GridPanel({
			stateId: 'support-system-settings-tasklist-grid',
			cls: "go-tasks-task-list",
			border: 1,
			tbar: [{
				xtype: 'tbtitle',
				text: t('Tasklist')
			}, '->', {
				xtype: "tbsearch"
			},{
				iconCls: 'ic-add',
				tooltip: t('Add'),
				handler: function (e, toolEl) {
					var dlg = new go.modules.community.tasks.TasklistDialog();
					dlg.setValues({
						role: "support"
					});
					dlg.show();
				}
			}],
			height: 300,
			store: new go.data.GroupingStore({
				groupField: "group",
				remoteGroup: true,
				remoteSort: true,
				fields: [
					'id',
					'name',
					{name: "group", type: "relation", mapping: "group.name"}
				],
				entityStore: "TaskList",
				filters: {role: {role: 'support'}},
				sortInfo: {
					field: 'name',
					direction: 'ASC'
				}
			}),
			columns: [{
				id: 'name',
				header: t('Name'),
				sortable: false,
				dataIndex: 'name',
				hideable: false,
				draggable: false,
				menuDisabled: true
			},{
				id: 'group',
				header: t('Group'),
				sortable: false,
				dataIndex: 'group',
				// groupRenderer: function(v, un, r, rowIndex, colIndex, ds) {
				// 	if(!v) {
				// 		return "";
				// 	}
				// }
			}],
			autoExpandColumn: "name",
			listeners: {
				render: () => {
					this.tasklistGrid.getStore().load();
				},
				rowdblclick: (grid, rowIndex, e) => {
					this.editTaskList(this.tasklistGrid.store.getAt(rowIndex).id);
				}
			},

			view: new go.grid.GroupingView({
				showGroupName: false,
				emptyText: '<i>description</i><p>' + t("No items to display") + '</p>',
				totalDisplay: false,
				hideGroupedColumn: true,
				forceFit: true,
				autoFill: true,
				emptyGroupText: "",
				actionConfig: {
					scope: this,
					menu: this.initMoreMenu()
				}
			})
			// viewConfig: {
			// 	emptyText: 	'<i>description</i><p>' +t("No items to display") + '</p>',
			// 	actionConfig: {
			// 		scope: this,
			// 		menu: this.initMoreMenu()
			// 	}
			// }
		});

		this.items = [
			{
				xtype: "fieldset",
				items: [
					{
						xtype: "tasklistcombo",
						role: "support",
						value: null,
						fieldLabel: t("Default tasklist"),
						hiddenName: "defaultTaskListId"
					},

					{
						xtype: "textfield",
						anchor: "100%",
						value: null,
						fieldLabel: t("Task URL template"),
						name: "taskUrlTemplate",
						hint: t("Override the URL the customer receives to view a support task. Useful when you use the API on your website. The tag '{id}' will be replaced with the task ID. eg. https://example.com/support/{id}")
					},

					{
						xtype: "formgroup",
						startWithItem: false,
						// hideLabel: false,
						// fieldLabel: t("E-mail accounts"),

						addButtonText: t("Add E-mail account"),
						name: "emailAccounts",
						itemCfg: {
							xtype: "formcontainer",
							cls: "go-hbox",
							items: [
								{
									anchor: "",
									xtype: "emailaccountcombo",
									hiddenName: "accountId",
									flex: 1
								},{
									xtype: "box",
									autoEl: 'i',
									cls: 'icon',
									html: 'arrow_forward',
									width: dp(24),
									style: "align-self: center"
								},
								{
									anchor: "",
									flex: 1,
									xtype: "tasklistcombo",
									role: "support",
									value: null
								}
							]
						}
					},

					this.tasklistGrid
					]
			}
		];


		this.callParent();
	},


	initMoreMenu : function() {
		this.moreMenu = new Ext.menu.Menu({
			items: [
				{
					itemId: "view",
					iconCls: 'ic-edit',
					text: t("Edit"),
					handler: function(item) {
						var record = this.tasklistGrid.store.getAt(item.parentMenu.rowIndex);
						this.editTaskList(record.id);
					},
					scope: this
				}
				,{
					itemId:"delete",
					iconCls: 'ic-delete',
					text: t("Delete"),
					handler: function(item) {
						var record = this.tasklistGrid.store.getAt(item.parentMenu.rowIndex);

						this.tasklistGrid.getSelectionModel().selectRecords([record]);
						this.tasklistGrid.deleteSelected();
					},
					scope: this
				}
			]
		});

		return this.moreMenu
	},

	editTaskList : function(id) {
		var dlg = new go.modules.community.tasks.TasklistDialog();
		dlg.load(id).show();
	}

});

