GO.billing.ExportCustomerReportDialog = Ext.extend(GO.Window,{

	exportController : "billing/exportCustomerReport",

	initComponent : function(){

		Ext.applyIf(this,{
			title: t("Customer report", "billing"),
			modal:false,
			height: 300,
			width: 360,
			layout:'form',
			closeAction:'hide',
			buttons: [
				{
					text: t("Ok"),
					handler: function(){this.submitForm()},
					scope:this
				},{
					text: t("Close"),
					handler: function(){this.hide()},
					scope:this
				}
			]
		});

		let now = new Date(),
			thisYear = parseInt(now.format("Y")),
			first_day_year = new Date(thisYear, 0, 1),
			last_day_year = new Date(thisYear + 1, 0, 0);

		const startDate = new Ext.form.DateField({
			name: 'start_date',
			format: GO.settings['date_format'],
			allowBlank:true,
			fieldLabel: t("Start"),
			value: first_day_year.format(GO.settings.date_format)
		});

		const endDate = new Ext.form.DateField({
			name: 'end_date',
			format: GO.settings['date_format'],
			allowBlank:true,
			fieldLabel: t("End"),
			value: last_day_year.format(GO.settings.date_format)
		});

		// multiple?
		const selectBook = new GO.billing.SelectBook({
			store:GO.billing.readableBooksStore
		});


		this.formPanel = new Ext.form.FormPanel({
			standardSubmit:true,
			cls:'go-form-panel',
			autoHeight:true,
			url:GO.url(this.exportController+'/export'),
			items:[ startDate, endDate , selectBook]
		});

		this.items=[
			this.formPanel
		]

		GO.dialog.ExportDialog.superclass.initComponent.call(this);
	},

	submitForm : function(){
		this.formPanel.form.getEl().dom.target='_blank';
		this.formPanel.form.getEl().dom.action = GO.url(this.exportController+'/export');


		this.formPanel.form.submit(
			{
				failure: function(form, action) {
					if(action.failureType == 'client')
						Ext.MessageBox.alert(t("Error"), t("You have errors in your form. The invalid fields are marked."));

				},
				scope: this
			});
	}

});
