GO.projects2.ProjectsTree = function(config){
	
	if(!config)
	{
		config = {};
	}

	this.treeLoader = new GO.base.tree.TreeLoader(
	{
//		dataUrl : GO.settings.modules.projects2.url+'json.php',
		dataUrl: GO.url('projects2/project/tree'),
//		baseParams:{task: 'projects_tree'},
		preloadChildren:true
	});

	this.treeLoader.on('beforeload', function(){
		var el =this.getEl();
		if(el)
			el.mask(t("Loading..."));
	}, this);

	this.treeLoader.on('load', function(){
		var el =this.getEl();
		if(el)
			el.unmask();
		
				
		this.updateState();
		
	}, this);

	config.autoScroll=true;
	config.animate=true;
	config.loader=this.treeLoader;
	config.rootVisible=false;
	config.containerScroll=true;
	config.collapsible=false;
	config.ddAppendOnly=true;
	config.containerScroll=true;
	config.ddGroup='ProjectsDD';
	config.enableDD=true;

	this.contextMenu = new GO.projects2.TreeContextMenu({treePanel:this});
	
	GO.projects2.ProjectsTree.superclass.constructor.call(this, config);


	




	this.hiddenNode = new Ext.tree.AsyncTreeNode({
		id:"hidden",
		text: "hidden",
		expanded: true,
		children:[
			{
				id: "all",
				iconCls: "ic-select-all blue",
				text: t("All projects", "projects2"),
				leaf: true,
				readonly: true
			},
			{
				draggable:false,
				id:'root',
				expanded:true,
				iconCls:'ic-storage orange',
				text:t("Root folder", "projects2")
			}
		]
	});

	this.setRootNode(this.hiddenNode);

	
	this.on('collapsenode', function(node)
	{		
		if(this.saveTreeState && node.childNodes.length)
			this.updateState();		
	},this);

	this.on('expandnode', function(node)
	{		
		if(node.id!="root" && this.saveTreeState && node.childNodes.length)
			this.updateState();
		
		
		//if root node is expanded then we are done loading the entire tree. After that we must start saving states
		if(node.id=="root"){			
			this.enableStateSave();



			let selectedNode;
			switch(this.project_id) {
				case -1:
					selectedNode = this.getNodeById("all");
					break;
				case 0:
					selectedNode = this.getNodeById("root");
					break;
				default:
					selectedNode = this.getNodeById(this.project_id);
					break;

			}
			this.getSelectionModel().select(selectedNode);

		}
	},this);
	
	this.on('contextmenu', function(node, e){
		e.preventDefault();

		var selModel = this.getSelectionModel();

		if(!selModel.isSelected(node))
		{
			selModel.clearSelections();
			selModel.select(node);
		}
		
		var coords = e.getXY();

		this.selectedNode=node;
		this.contextMenu.showAt([coords[0], coords[1]]);

	}, this);
	
	this.on('click', function(node)
	{
		if(node.id=='all') {
			this.project_id=-1;
		}else if(node.id=='root')
			this.project_id=0;
		else
			this.project_id=node.id;
	}, this);
	
	this.addEvents({selectproject:true})
	
	this.on('beforenodedrop', function(e)
	{	
		if(e.data.selections)
		{
			var selections = e.data.selections;
		}else
		{
			var record = {};
			record.data={};
			record.data['id']=e.data.node.id;
			var selections = [record];
		}
		
		this.moveProject(e.target.id, selections);
	},
	this);
	
	this.on('nodedragover', function(dragEvent)
	{
		if(!dragEvent.dropNode)
		{
			if(dragEvent.target.attributes.readonly)
			{
				return false;
			}

			var drag_allowed = true;
			for(var i=0;i<dragEvent.data.selections.length; i++)
			{				
				var moveid = dragEvent.data.selections[i].data.id;
				var targetid = dragEvent.target.id;					
				if(moveid==targetid)
				{
					drag_allowed = false;
				}					
				
				var dragNode = this.getNodeById(moveid);
				if(dragNode){
					if(dragEvent.target.isAncestor(dragNode))
					{
						drag_allowed = false;
					}

					var parentId = dragNode.parentNode.id;
					if(parentId == dragEvent.target.id)
					{
						drag_allowed = false;
					}
				}
				
				if(!drag_allowed)
				{
					return false;
				}				
			}
			return true;			
		}else
		{
			var parentId = this.getNodeById(dragEvent.dropNode.id).parentNode.id;					
			if(parentId == dragEvent.target.id)
			{
				return false
			}
		
			return true;		
		}
	}, this);
				
}

Ext.extend(GO.projects2.ProjectsTree, Ext.tree.TreePanel,{
	project_id : 0,
	
	saveTreeState : false,
	loadingDone : false,
	
	reloadActiveNode : function()
	{		
		if(this.project_id==-1)
			this.project_id=0;
		
		var activeNode = this.getNodeById(this.project_id);
		
		if(activeNode && activeNode.parentNode)
		{
			delete activeNode.parentNode.attributes.children;
			activeNode.parentNode.reload();
		}else
		{
			this.getRootNode().reload();
		}
	},
	
	getActiveGridStore : function() {
		return this.grid.store;
	},
	
	moveProject : function(destination, records)
	{
		var move_sources = Array();
		for(var i=0; i<records.length; i++)
		{
			move_sources.push(records[i].data['id']);
		}
		function cb() {
			Ext.Ajax.request({
				url: GO.url('projects2/project/move'),
				params: {
					task: 'move_project',
					move_sources: Ext.encode(move_sources),
					move_destination: destination
				},
				callback: function (options, success, response) {
					var responseParams = Ext.decode(response.responseText);
					if (!responseParams.success) {
						Ext.MessageBox.alert(t("Error"), responseParams.feedback);
						this.getNodeById("root").reload();
					} else {
						var store = this.getActiveGridStore();
						if (!destination || destination == this.project_id) {
							store.reload();
						} else if (move_sources) {
							for (var i = 0; i < move_sources.length; i++) {
								var record = store.getById(move_sources[i]);
								if (record) {
									store.reload();
									break;
								}
							}
						}

						var destinationNode = this.getNodeById(destination);
						if (destinationNode) {
							delete destinationNode.attributes.children;
							destinationNode.reload();
						}

						if (move_sources) {
							for (var i = 0; i < move_sources.length; i++) {
								var node = this.getNodeById(move_sources[i]);
								if (node) {
									node.remove();
								}
							}
						}
					}
				},
				scope: this
			});
		}
		go.User.confirmOnMove ?
			Ext.Msg.confirm(t('Confirm'), t('Are you sure you want to move the item(s)?'), function(btn) { if(btn == 'yes') cb.call(this)}, this) :
			cb.call(this);
	},
	
	getExpandedNodes : function(){
		var expanded = new Array();
		this.getRootNode().cascade(function(n){
			if(n.expanded){
			expanded.push(n.attributes.id);
			}
		});
		
		return expanded;
	},
					
	enableStateSave : function(){
		if(Ext.Ajax.isLoading(this.getLoader().transId)){
			this.enableStateSave.defer(100, this);
			this.loadingDone=false;
		}else
		{
			if(!this.loadingDone){
				this.loadingDone=true;
				this.enableStateSave.defer(100, this);
			}else{
				this.saveTreeState=true;
			}
		}
	},
	
	disableStateSave : function(){
		this.loadingDone=false;
		this.saveTreeState=false;
	},
	
	updateState : function(){
		GO.request({
			url:"projects2/project/saveTreeState",
			params:{
				expandedNodes:Ext.encode(this.getExpandedNodes())
			}
		});
	}
	
});
