/**
 * Copyright Intermesh
 *
 * This file is part of Group-Office. You should have received a copy of the
 * Group-Office license along with Group-Office. See the file /LICENSE.TXT
 *
 * If you have questions write an e-mail to info@intermesh.nl
 *
 * @version $Id: ContractIncomeGrid.js 22922 2018-01-12 08:01:04Z mschering $
 * @copyright Copyright Intermesh
 * @author Michael de Hart <mdhart@intermesh.nl>
 */


GO.projects2.ContractIncomeGrid = Ext.extend(GO.grid.GridPanel,{

	initComponent : function(){
		
		var today = new Date();

		this.end = new Date(today.setMonth(today.getMonth()+1));

		this.summary = new Ext.grid.JsonSummary();

		this.store = new GO.data.JsonStore({
			url:GO.url("projects2/income/store"),
			fields:['id','project_id', 'project_path', 'project_name', 'description','reference_no', 'amount','is_invoiced','period_start','period_end','invoice_at','invoice_number', 'type','hide_print', 'comments','company_name'],
			baseParams: {
				companyId: 0,
				withCompany:true,
				contractsOnly:true
			}
		});

		Ext.apply(this,{
			plugins: [this.summary],
			standardTbar:false,
			baseParams: {
				end: Math.round(+this.end/1000)
			},
			tbar:[
				t("From", "projects2"),
				this.from = new Ext.form.DateField({
					listeners: {
						change: function() {
							this.store.baseParams.start_date = Math.round(+this.from.getValue()/1000);
							this.store.reload();
						},
						select: function() {
							this.store.baseParams.start_date = Math.round(+this.from.getValue()/1000);
							this.store.reload();
						},
						scope: this
					}
				}),
				t("Until", "projects2"),
				this.till = new Ext.form.DateField({
					value: this.end,
					listeners: {
						change: function() {
							this.store.baseParams.end = Math.round(+this.till.getValue()/1000);
							this.store.reload();
						},
						select: function() {
							this.store.baseParams.end = Math.round(+this.till.getValue()/1000);
							this.store.reload();
						},
						scope: this
					}
				}),
				'-',
				t("Company"),
				
				this.selectCompany = new go.modules.community.addressbook.ContactCombo({					
					isOrganization: true,
					fieldLabel: t("Company"),
					name: 'company',
					hiddenName: 'companyId',
					emptyText: t("Please select a company", "addressbook"),
					listeners: {
						change: function() {
							this.store.baseParams.companyId = this.selectCompany.getValue();
							this.store.reload();
						},
						select: function() {
							this.store.baseParams.companyId = this.selectCompany.getValue();
							this.store.reload();
						},
						scope: this
					}
				}),
				'-',
				new GO.form.SearchField({
					store: this.store,
					width:150
				})
			],
			store: this.store,
			border: false,
			paging: true,
			editDialogClass: GO.projects2.IncomeDialog,
			cm: new Ext.grid.ColumnModel({
				defaults:{
					sortable:true
				},
				columns:[{
					dataIndex: 'is_invoiced',
					renderer: function(v,m,r) { 
						if(r.data.is_invoiced){
							return '<div title="'+t("Invoiced", "projects2")+'" class="tasks-complete-icon"></div>';
						}
					}
					,summaryRenderer:function(v, meta, r){
						return t("Total");
					}
					,width: 10
				},
				{
					header: t("Company"),
					dataIndex: 'company_name'
				},{
					header: t("Name"),
					dataIndex: 'project_name',
					hidden:true
				},{
					header: t("Path", "projects2"),
					dataIndex: 'project_path'
				},{
					header: t("Description"),
					dataIndex: 'description'
				},{
					header: t("Reference no.", "projects2"),
					dataIndex: 'reference_no'
				},{
					header: t("Amount", "projects2"),
					dataIndex: 'amount',
					align: 'right',
					renderer: GO.util.format.valuta
				},{
					header: t("Invoice at", "projects2"),
					dataIndex: 'invoice_at',
					renderer: function(value){
						return !value.dateFormat ? value : value.dateFormat(GO.settings.date_format);
					},
					summaryRenderer:function(){
						return '&nbsp;';
					}
				},{
					header: t("Invoice No.", "projects2"),
					dataIndex: 'invoice_number'
				},{
					header: t("Type"),
					dataIndex: 'type',
					renderer: function(v) {
						return (v==1) ? t("Contract Price", "projects2") : t("Post calculation", "projects2");
					},
					summaryRenderer:function(){
						return '&nbsp;';
					}
				},{
					header: t("Comment"),
					dataIndex: 'comments',
					sortable: true,
					hidden: true
				},
					{
						xtype: 'actioncolumn',
						width: 70,
						sortable: false,
						items: [{
							iconCls: "ic-print",
							text: '',
							tooltip: t('Income'),
							isDisabled: (v, meta, rec) => {
								return rec.data.hide_print;
							},
							handler: (me, row, col) => {
								const record = me.store.getAt(row);
								window.open(GO.url('projects2/income/export', {income_id: record.id}));
							}
						},{
							iconCls: "ic-edit",
							tooltip: t("Edit"),
							text: '',
							handler: (me, row, col) => {
								if (me.editDialogClass) {
									const record = me.store.getAt(row);
									me.showEditDialog(record.id, {}, record);
								}
							}
						}],
						summaryRenderer: () => {
							return '&nbsp;';
						}
					}
				]
			})
		});
		
		GO.projects2.ContractIncomeGrid.superclass.initComponent.call(this);		
	},

	
	btnAdd : function(){
		if(this.editDialogClass){
			this.showEditDialog(0,{
				project_id:this.store.baseParams.project_id
			});
		}
	},
	
	exportFile : function(record,action) {
		
		window.open(GO.url('projects2/income/export',{income_id:record.id}));
		
	},
	
	showEditDialog : function(id, config, record) {
		var config = config || {};
		config['project_id'] = record.data.project_id;
		GO.projects2.ContractIncomeGrid.superclass.showEditDialog.call(this,id,config,record);
	}
});
