/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { FieldEventMap } from "./Field.js";
import { Config } from "../Observable";
import { InputField } from "./InputField";
type CheckBoxType = 'box' | 'switch' | 'button';
export interface CheckboxField {
    get input(): HTMLInputElement;
}
/**
 * Checkbox field
 *
 * @see Form
 */
export declare class CheckboxField extends InputField {
    /**
     *
     * @param type Render the checkbox as a checkbox, switch or toggle button
     */
    constructor(type?: CheckBoxType);
    protected baseCls: string;
    protected applyTitle(): void;
    focus(o?: FocusOptions): void;
    protected createLabel(): void;
    protected fireChangeOnBlur: boolean;
    protected createControl(): HTMLDivElement;
    set color(v: string);
    get color(): string;
    set value(v: boolean);
    get value(): boolean;
}
export type CheckboxFieldConfig = Omit<Config<CheckboxField, FieldEventMap<CheckboxField>>, "type"> & {
    type?: CheckBoxType;
};
/**
 * Shorthand function to create {@see CheckboxField}
 *
 * @param config
 */
export declare const checkbox: (config?: CheckboxFieldConfig) => CheckboxField;
export {};
//# sourceMappingURL=CheckboxField.d.ts.map