import { Field, FieldEventMap, FieldValue } from "./Field";
import { Component } from "../Component";
import { Config } from "../Observable";
/**
 * Chips component
 */
export declare class ChipsField extends Field {
    protected baseCls: string;
    private _editor?;
    private chipsContainer?;
    /**
     * Function that transforms the user text input to a chip.
     *
     * If it returns an empty value no chip will be rendered
     *
     * @param text
     */
    textInputToValue: (text: string) => Promise<any>;
    /**
     * Renders a value to the chip component
     * @param value
     */
    chipRenderer: (chip: Component, value: any) => Promise<void>;
    get editor(): Component;
    protected createControl(): HTMLElement | undefined;
    get value(): FieldValue[];
    set value(v: FieldValue[]);
    private onEditorKeyDown;
    private createChip;
    protected get itemContainerEl(): HTMLElement;
    private selectedIndex;
    private clearSelection;
    private select;
    protected internalSetValue(v: any[]): void;
    protected internalRender(): HTMLElement;
    private renderValue;
    focus(o?: FocusOptions): void;
}
type ChipsConfig = Config<ChipsField, FieldEventMap<ChipsField>> & Partial<Pick<ChipsField, "textInputToValue" | "chipRenderer">>;
/**
 * Shorthand function to create {@see ChipsField}
 *
 * @param config
 */
export declare const chips: (config?: ChipsConfig) => ChipsField;
export {};
//# sourceMappingURL=ChipsField.d.ts.map