/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Michael de Hart <mdhart@intermesh.nl>
 */
import { Field, FieldEventMap } from "./Field.js";
import { Config } from "../Observable";
type MapFieldConfig = Config<MapField, FieldEventMap<MapField>, "buildField">;
type FieldBuilder = (value: MapFieldValue | undefined) => Field;
type MapFieldValue = Record<string, any>;
export declare class MapField extends Field {
    buildField: FieldBuilder;
    /**
     * Set to the name of the field holding the key. If not given a key will be generated.
     */
    keyFieldName?: string;
    constructor(buildField: FieldBuilder);
    protected baseCls: string;
    protected renderControl(): void;
    set value(v: MapFieldValue);
    get value(): MapFieldValue;
    isEmpty(): boolean;
    /**
     * Add value to the map.
     *
     * Also fires change event
     *
     * @param data
     * @param key
     */
    add(data: MapFieldValue, key?: string | undefined): void;
    private internalAdd;
    private _nextKey;
    protected nextKey(): number;
    reset(): void;
}
export declare const mapfield: (config: MapFieldConfig, ...items: Field[]) => MapField;
export {};
//# sourceMappingURL=MapField.d.ts.map