/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { comp, Component, createComponent } from "./Component.js";
export class DescriptionList extends Component {
    constructor() {
        super("dl");
        this.baseCls = 'goui-dl';
    }
    internalRender() {
        const el = super.internalRender();
        this.renderList();
        return el;
    }
    /**
     * Set the records to display
     *
     * @example
     * ```
     * const records: DLRecord = [
     * 			['Number', record.number],
     * 			['Description', record.description],
     * 			['Created At', Format.date(record.createdAt)]
     * 		];
     * dl.setRecords(records);
     * ```
     * @param records
     */
    set records(records) {
        this._records = records;
        this.renderList();
    }
    get records() {
        return this._records || [];
    }
    renderList() {
        this.items.clear();
        this.records.forEach((record) => {
            this.items.add(comp({
                tagName: "dt",
                text: record.shift()
            }));
            record.forEach((r) => {
                const dd = comp({
                    tagName: "dd"
                });
                if (typeof r == 'function')
                    r(dd);
                else {
                    dd.text = r + "";
                }
                this.items.add(dd);
            });
        });
    }
}
/**
 * Shorthand function to create {@see DescriptionList}
 *
 * @param config
 * @param items
 */
export const dl = (config, ...items) => createComponent(new DescriptionList(), config, items);
//# sourceMappingURL=DescriptionList.js.map