/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { Toolbar } from "./Toolbar.js";
import { btn } from "./Button.js";
import { comp, createComponent } from "./Component.js";
export class Paginator extends Toolbar {
    constructor(store) {
        super();
        this.store = store;
        this.baseCls = "goui-toolbar goui-paginator";
        this.items.add(this.prev = btn({
            icon: "chevron_left",
            text: "Previous",
            disabled: true,
            handler: async () => {
                await this.store.loadPrevious();
            }
        }), comp({
            flex: 1
        }), this.next = btn({
            icon: "chevron_right",
            text: "Next",
            disabled: true,
            handler: async () => {
                await this.store.loadNext();
            }
        }));
        this.store.on("load", () => {
            this.onStoreLoad();
        });
    }
    onStoreLoad() {
        this.prev.disabled = !this.store.hasPrevious();
        this.next.disabled = !this.store.hasNext();
    }
}
/**
 * Shorthand function to create {@see Paginator}
 *
 * @param config
 */
export const paginator = (config) => createComponent(new Paginator(config.store), config);
//# sourceMappingURL=Paginator.js.map