/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { Field, FieldEventMap } from "./Field.js";
import { Config } from "../Observable";
/**
 * ColorField component
 *
 * @see Form
 */
export declare class ColorField extends Field {
    private readonly picker;
    private readonly pickerButton;
    constructor();
    private createPicker;
    protected createControl(): undefined | HTMLElement;
    setInvalid(msg: string): void;
    clearInvalid(): void;
    set value(v: any);
    get value(): any;
}
/**
 * Shorthand function to create {@see TextField}
 *
 * @param config
 */
export declare const colorfield: (config?: Config<ColorField, FieldEventMap<ColorField>>) => ColorField;
//# sourceMappingURL=ColorField.d.ts.map